/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.system;

import cfca.sadk.envelope.SessionEncryptMode;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.CompatibleContext;
import cfca.sadk.system.logging.LoggerManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public final class CompatibleConfig
extends CompatibleContext {
    public static final int BUFFER_SIZE = 65536;
    public static final boolean SM2OutputFormatWithZFlag;
    public static final int SM2OutputFormatEncryptedBytes;
    public static final int SM2OutputFormatSignedBytes;
    public static final int SM2DecryptedFormatEncryptedBytes;
    public static final int SM2VerifiedFormatSignedBytes;
    public static final boolean SM2VerifiedWithoutZCompatible;
    public static final int P10RequestFormatSignedBytes;
    public static final boolean P10RequestVerifiedSignedFlag;
    public static final int FILEANDBUFFER_BIG_FILE_BUFFER;
    public static final int FILEANDBUFFER_SOURCE_FILE_MAXSIZE;
    public static final int FILEANDBUFFER_SIGNED_FILE_MAXSIZE;
    public static final int FILEANDBUFFER_ENVELOPE_FILE_MAXSIZE;
    public static final int FILEANDBUFFER_BIGGEST_FILE_MAXSIZE;
    public static final boolean LOGKACK_AUTOLOAD_SETTING;
    public static final int SM2EnvelopeEncryptMode;
    public static final boolean SM2CheckHardLibOriginEncryptOutFormat;
    public static final int SM2HardLibOriginEncryptOutFormat;
    public static final boolean C200CARDLOGIN;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static final Properties loadFromFile() {
        Properties properties;
        block18: {
            properties = new Properties();
            InputStream in = null;
            try {
                File primaryFile = new File("/etc/compatible.cfg");
                if (primaryFile.exists() && primaryFile.isFile()) {
                    LoggerManager.systemLogger.info("Loading compatible.cfg from AbsolutePath[have]: " + primaryFile.getAbsolutePath());
                    in = new FileInputStream(primaryFile);
                } else {
                    LoggerManager.systemLogger.info("Loading compatible.cfg from AbsolutePath[none]: " + primaryFile.getAbsolutePath());
                    File sencodaryFile = new File("config/compatible.cfg");
                    if (sencodaryFile.exists() && sencodaryFile.isFile()) {
                        LoggerManager.systemLogger.info("Loading compatible.cfg from RelativePath[have]: " + sencodaryFile.getAbsolutePath());
                        in = new FileInputStream(sencodaryFile);
                    } else {
                        LoggerManager.systemLogger.info("Loading compatible.cfg from AbsolutePath[none]: " + sencodaryFile.getAbsolutePath());
                        LoggerManager.systemLogger.info("Loading compatible.cfg from  *.jar/compatible.cfg");
                        in = CompatibleConfig.class.getClassLoader().getResourceAsStream("compatible.cfg");
                        URL url = CompatibleConfig.class.getClassLoader().getResource("compatible.cfg");
                        if (in == null) {
                            LoggerManager.systemLogger.info("Loading compatible.cfg from jarFile Failure: " + url);
                        } else {
                            LoggerManager.systemLogger.info("Loading compatible.cfg from jarFile Success: " + url);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                in = null;
            }
            if (in == null) {
                LoggerManager.systemLogger.info("Loading compatible.cfg failure from:");
                LoggerManager.systemLogger.info("1. From AbsolutePath /etc/compatible.cfg");
                LoggerManager.systemLogger.info("2. From RelativePath config/compatible.cfg");
                LoggerManager.systemLogger.info("3. From jarFIle  *.jar/compatible.cfg");
            } else {
                properties.load(in);
                Object var6_7 = null;
                try {
                    in.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            break block18;
            {
                catch (Exception e) {
                    e.printStackTrace();
                    Object var6_8 = null;
                    try {
                        in.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                try {
                    in.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
        return properties;
    }

    private static final int integerFrom(Properties properties, String key, int defValue) {
        int value = defValue;
        try {
            value = Integer.decode(properties.getProperty(key, Integer.toString(defValue)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    private static final boolean booleanFrom(Properties properties, String key, String defValue) {
        return "true".equalsIgnoreCase(properties.getProperty(key, defValue));
    }

    public static final String dump() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n SADK CompatibleConfig:");
        buffer.append("\n###############################################");
        buffer.append("\n  SM2OutputFormatWithZFlag=");
        buffer.append(SM2OutputFormatWithZFlag);
        buffer.append("\n  SM2OutputFormatEncryptedBytes=");
        buffer.append(SM2OutputFormatEncryptedBytes);
        buffer.append("\n  SM2OutputFormatSignedBytes=");
        buffer.append(SM2OutputFormatSignedBytes);
        buffer.append("\n  SM2DecryptedFormatEncryptedBytes=");
        buffer.append(SM2DecryptedFormatEncryptedBytes);
        buffer.append("\n  SM2VerifiedFormatSignedBytes=");
        buffer.append(SM2VerifiedFormatSignedBytes);
        buffer.append("\n  SM2VerifiedWithoutZCompatible=");
        buffer.append(SM2VerifiedWithoutZCompatible);
        buffer.append("\n  P10RequestFormatSignedBytes=");
        buffer.append(P10RequestFormatSignedBytes);
        buffer.append("\n  P10RequestVerifiedSignedFlag=");
        buffer.append(P10RequestVerifiedSignedFlag);
        buffer.append("\n  FILEANDBUFFER_BIG_FILE_BUFFER=");
        buffer.append(FILEANDBUFFER_BIG_FILE_BUFFER);
        buffer.append("\n  FILEANDBUFFER_SOURCE_FILE_MAXSIZE=");
        buffer.append(FILEANDBUFFER_SOURCE_FILE_MAXSIZE);
        buffer.append("\n  FILEANDBUFFER_SIGNED_FILE_MAXSIZE=");
        buffer.append(FILEANDBUFFER_SIGNED_FILE_MAXSIZE);
        buffer.append("\n  FILEANDBUFFER_ENVELOPE_FILE_MAXSIZE=");
        buffer.append(FILEANDBUFFER_ENVELOPE_FILE_MAXSIZE);
        buffer.append("\n  FILEANDBUFFER_BIGGEST_FILE_MAXSIZE=");
        buffer.append(FILEANDBUFFER_BIGGEST_FILE_MAXSIZE);
        buffer.append("\n###############################################");
        return buffer.toString();
    }

    static {
        Properties properties = CompatibleConfig.loadFromFile();
        SM2OutputFormat = SM2OutputFormatEncryptedBytes = CompatibleConfig.integerFrom(properties, "SM2OutputFormatEncryptedBytes", 1);
        SM2OutputFormatSignedBytes = CompatibleConfig.integerFrom(properties, "SM2OutputFormatSignedBytes", 1);
        SM2DecryptedFormatEncryptedBytes = CompatibleConfig.integerFrom(properties, "SM2DecryptedFormatEncryptedBytes", 21);
        SM2VerifiedWithoutZCompatible = CompatibleConfig.booleanFrom(properties, "SM2VerifiedWithoutZCompatible", "false");
        SM2EnvelopeEncryptMode = CompatibleConfig.integerFrom(properties, "SM2EnvelopeEncryptMode", SessionEncryptMode.JSOFTSESSION.sessionType);
        SM2CheckHardLibOriginEncryptOutFormat = CompatibleConfig.booleanFrom(properties, "SM2CheckHardLibOriginEncryptOutFormat", "false");
        SM2HardLibOriginEncryptOutFormat = CompatibleConfig.integerFrom(properties, "SM2HardLibOriginEncryptOutFormat", 1);
        SM2VerifiedFormatSignedBytes = CompatibleConfig.integerFrom(properties, "SM2VerifiedFormatSignedBytes", 17);
        P10RequestFormatSignedBytes = CompatibleConfig.integerFrom(properties, "P10RequestFormatSignedBytes", 1);
        P10RequestVerifiedSignedFlag = CompatibleConfig.booleanFrom(properties, "P10RequestVerifiedSignedFlag", "true");
        SM2OutputFormatWithZFlag = CompatibleConfig.booleanFrom(properties, "SM2OutputFormatWithZFlag", "true");
        C200CARDLOGIN = CompatibleConfig.booleanFrom(properties, "C200CARDLOGIN", "true");
        FILEANDBUFFER_BIG_FILE_BUFFER = 0x100000 * CompatibleConfig.integerFrom(properties, "FILEANDBUFFER.BIG_FILE_BUFFER", 5);
        FILEANDBUFFER_SOURCE_FILE_MAXSIZE = 0x100000 * CompatibleConfig.integerFrom(properties, "FILEANDBUFFER.SOURCE_FILE_MAXSIZE", 50);
        FILEANDBUFFER_SIGNED_FILE_MAXSIZE = 0x100000 * CompatibleConfig.integerFrom(properties, "FILEANDBUFFER.SIGNED_FILE_MAXSIZE", 51);
        FILEANDBUFFER_ENVELOPE_FILE_MAXSIZE = 0x100000 * CompatibleConfig.integerFrom(properties, "FILEANDBUFFER.ENVELOPE_FILE_MAXSIZE", 51);
        FILEANDBUFFER_BIGGEST_FILE_MAXSIZE = 0x100000 * CompatibleConfig.integerFrom(properties, "FILEANDBUFFER.BIGGEST_FILE_MAXSIZE", 55);
        LOGKACK_AUTOLOAD_SETTING = CompatibleConfig.booleanFrom(properties, "LOGKACK_AUTOLOAD_SETTING", "true");
        LoggerManager.systemLogger.info(CompatibleConfig.dump());
    }
}

