/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.system;

import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.GenKeyAttribute;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.card.SM2Key;
import cfca.sadk.lib.crypto.card.c200.ECCCardPrivateKey;
import cfca.sadk.lib.crypto.card.c200.ECCCardPublicKey;
import cfca.sadk.lib.crypto.card.c200.SM2CardKey;
import cfca.sadk.lib.crypto.card.c200.SM2CardPrivateKey;
import cfca.sadk.lib.crypto.card.c200.SM2CardPublicKey;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.util.ASN1Dump;
import cfca.sadk.org.bouncycastle.util.Strings;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.system.Environments;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;

public final class SADKDebugger {
    static final int dumpLength = 10240;
    private static volatile SADKDebugger singleton;

    private SADKDebugger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SADKDebugger setDebugger() {
        if (singleton != null) return singleton;
        Class<SADKDebugger> clazz = SADKDebugger.class;
        synchronized (SADKDebugger.class) {
            if (singleton != null) return singleton;
            SADKDebugger debugger = new SADKDebugger();
            Environments.environments();
            singleton = debugger;
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public static final String dump(BigInteger value) {
        String message = null;
        message = value == null ? "none" : "[hex]" + value.toString(16);
        return message;
    }

    public static final String dump(Session session) {
        String message = null;
        message = session == null ? "none" : "[session]" + session.getClass().getName();
        return message;
    }

    public static final String dump(InputStream stream) {
        String message = null;
        message = stream == null ? "none" : "[stream]" + stream.getClass().getName();
        return message;
    }

    public static final String dump(OutputStream stream) {
        String message = null;
        message = stream == null ? "none" : "[stream]" + stream.getClass().getName();
        return message;
    }

    public static final String dump(Mechanism mechanism) {
        String message = null;
        try {
            message = mechanism == null ? "none" : mechanism.toString();
        }
        catch (Exception e) {
            message = "FailureMechanism";
        }
        return message;
    }

    public static final String dump(String text) {
        String message = null;
        message = text == null ? "none" : (text.length() > 10240 ? "more than 10K" : text);
        return message;
    }

    public static final StringBuffer dump(PublicKey publicKey) {
        StringBuffer message = new StringBuffer();
        try {
            if (publicKey == null) {
                message.append("none");
            } else {
                message.append(publicKey);
                message.append("\n PublicKeyEncoding: [hex]" + Hex.toHexString(publicKey.getEncoded()));
            }
        }
        catch (Exception e) {
            message.append("FailurePublicKey");
        }
        return message;
    }

    public static final String dump(PrivateKey pirvateKey) {
        String message = null;
        try {
            if (pirvateKey == null) {
                message = "none";
            } else if (pirvateKey instanceof RSAPrivateKey) {
                BigInteger modulus = ((RSAPrivateKey)pirvateKey).getModulus();
                String modulusText = modulus == null ? "" : modulus.toString(16);
                message = pirvateKey.getAlgorithm() + ":  modulus= " + modulusText;
            } else if (pirvateKey instanceof SM2PrivateKey) {
                SM2PublicKey pubKey = ((SM2PrivateKey)pirvateKey).getSM2PublicKey();
                BigInteger pubx = pubKey.getPubX_Int();
                BigInteger puby = pubKey.getPubY_Int();
                message = pirvateKey.getAlgorithm() + ":  pubx =" + pubx.toString(16) + " puby =" + puby.toString(16);
            } else {
                message = pirvateKey.getAlgorithm() + ":  hidden";
            }
        }
        catch (Exception e) {
            message = "FailurePrivateKey";
        }
        return message;
    }

    public static final StringBuffer dump(KeyPair keypair) {
        StringBuffer message = new StringBuffer();
        try {
            if (keypair == null) {
                message.append("none");
            } else {
                message.append("\n PrivateKey: " + keypair.getPrivate().getAlgorithm() + ": hidden ");
                message.append("\n PublicKeyEncoding: [hex]" + Hex.toHexString(keypair.getPublic().getEncoded()));
                message.append(keypair.getPublic());
            }
        }
        catch (Exception e) {
            message.append("FailureMechanism");
        }
        return message;
    }

    public static final String dump(Key key) {
        String message = null;
        try {
            message = key == null ? "none" : (key instanceof PrivateKey ? key.getAlgorithm() + ": hidden " : key.getAlgorithm() + "[hex]" + Hex.toHexString(key.getEncoded()));
        }
        catch (Exception e) {
            message = "FailureKey";
        }
        return message;
    }

    public static final String dump(CBCParam param) {
        String message = null;
        try {
            message = param == null ? "none" : (param.getIv() == null ? "null" : "[hex]" + Hex.toHexString(param.getIv()));
        }
        catch (Exception e) {
            message = "FailureCBCParam";
        }
        return message;
    }

    public static final String dump(ASN1Encodable obj) {
        String message = null;
        try {
            message = obj == null ? "none" : ASN1Dump.dumpAsString(obj, true);
        }
        catch (Exception e) {
            message = "FailureASN1Encodable";
        }
        return message;
    }

    public static final String dump(ASN1Primitive obj) {
        String message = null;
        try {
            message = obj == null ? "none" : ASN1Dump.dumpAsString(obj, true);
        }
        catch (Exception e) {
            message = "FailureASN1Primitive";
        }
        return message;
    }

    public static final String dump(X509Cert cert) {
        String message = null;
        try {
            message = cert == null ? "none" : cert.toString();
        }
        catch (Exception e) {
            message = "FailureX509Cert";
        }
        return message;
    }

    public static final String dump(X509Cert[] certs) {
        String message = null;
        try {
            if (certs == null || certs.length == 0) {
                message = "none";
            } else {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < certs.length; ++i) {
                    buffer.append(certs[i]);
                }
                message = buffer.toString();
            }
        }
        catch (Exception e) {
            message = "FailureX509Cert";
        }
        return message;
    }

    public static final String dump(byte[] data) {
        String message = null;
        try {
            message = data == null ? "none" : (data.length > 10240 ? "more than 10K" : "[hex]" + Hex.toHexString(data));
        }
        catch (Exception e) {
            message = "FailureData";
        }
        return message;
    }

    public static final String dumpBase64(byte[] data) {
        String message = null;
        try {
            message = data == null ? "none" : (data.length > 10240 ? "more than 10K" : "[base64]" + Strings.fromByteArray(data));
        }
        catch (Exception e) {
            message = "FailureData";
        }
        return message;
    }

    public static String dump(SM2Key cardKey) {
        String message = null;
        try {
            message = cardKey == null ? "none" : (cardKey.getDefaultZ() == null ? "noneZ" : Hex.toHexString(cardKey.getDefaultZ()));
        }
        catch (Exception e) {
            message = "failureSM2CardKey";
        }
        return message;
    }

    public static String dump(SM2CardKey cardKey) {
        String message = null;
        try {
            message = cardKey == null ? "none" : cardKey.toString();
        }
        catch (Exception e) {
            message = "failureSM2CardKey";
        }
        return message;
    }

    public static String dump(SM2CardPrivateKey cardKey) {
        String message = null;
        try {
            message = cardKey == null ? "none" : cardKey.toString();
        }
        catch (Exception e) {
            message = "failureSM2CardPrivateKey";
        }
        return message;
    }

    public static String dump(SM2CardPublicKey cardKey) {
        String message = null;
        try {
            message = cardKey == null ? "none" : cardKey.toString();
        }
        catch (Exception e) {
            message = "failureSM2CardPublicKey";
        }
        return message;
    }

    public static String dump(ECCCardPrivateKey cardKey) {
        String message = null;
        try {
            message = cardKey == null ? "none" : cardKey.toString();
        }
        catch (Exception e) {
            message = "failureECCCardPrivateKey";
        }
        return message;
    }

    public static String dump(ECCCardPublicKey cardKey) {
        String message = null;
        try {
            message = cardKey == null ? "none" : cardKey.toString();
        }
        catch (Exception e) {
            message = "failureECCCardPublicKey";
        }
        return message;
    }

    public static String dump(GenKeyAttribute genKeyAttribute) {
        String message = null;
        try {
            message = genKeyAttribute == null ? "none" : genKeyAttribute.toString();
        }
        catch (Exception e) {
            message = "failureGenKeyAttribute";
        }
        return message;
    }

    public static final StringBuffer dump(SM2PublicKey publicKey) {
        StringBuffer message = new StringBuffer();
        try {
            if (publicKey == null) {
                message.append("none");
            } else {
                message.append(publicKey);
                message.append("\n PublicKeyEncoding: [hex]" + Hex.toHexString(publicKey.getEncoded()));
            }
        }
        catch (Exception e) {
            message.append("FailurePublicKey");
        }
        return message;
    }

    public static final String dump(SM2PrivateKey pirvateKey) {
        String message = null;
        try {
            message = pirvateKey == null ? "none" : pirvateKey.getAlgorithm() + ": hidden";
        }
        catch (Exception e) {
            message = "FailurePrivateKey";
        }
        return message;
    }
}

