/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.config;

import com.elitesland.security.config.bean.JwtProperties;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.RequestParameterBuilder;
import springfox.documentation.schema.ScalarType;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.ParameterType;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class YdSwaggerConfig {
    @Value(value="${swagger.title}")
    private String title;
    @Value(value="${swagger.base.package}")
    private String basePackage;
    @Value(value="${swagger.description}")
    private String description;
    @Value(value="${swagger.url}")
    private String url;
    @Value(value="${swagger.contact.name}")
    private String contactName;
    @Value(value="${swagger.contact.url}")
    private String contactUrl;
    @Value(value="${swagger.contact.email}")
    private String contactEmail;
    @Value(value="${swagger.version}")
    private String version;
    private final JwtProperties jwtProperties;

    @Bean
    public Docket createDemoRestApi() {
        return new Docket(DocumentationType.SWAGGER_2).groupName("DDKY\u6a21\u5757API").apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)"com.elitesland.controller")).paths(PathSelectors.any()).build().globalRequestParameters(this.setHeaderToken());
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.title).description(this.description).termsOfServiceUrl(this.url).contact(new Contact(this.contactName, this.contactUrl, this.contactEmail)).version(this.version).build();
    }

    private List<RequestParameter> setHeaderToken() {
        ArrayList<RequestParameter> pars = new ArrayList<RequestParameter>();
        RequestParameterBuilder tokenPar = new RequestParameterBuilder();
        RequestParameter tokenParameter = tokenPar.name(this.jwtProperties.getHeader()).description("JWT Token Request Header").required(Boolean.valueOf(false)).in(ParameterType.HEADER).query(q -> q.model(m -> m.scalarModel(ScalarType.STRING))).build();
        pars.add(tokenParameter);
        return pars;
    }

    public YdSwaggerConfig(JwtProperties jwtProperties) {
        this.jwtProperties = jwtProperties;
    }
}

