/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.external.cpcn.core.utils;

import com.elitesland.external.cpcn.core.param.AttachInfoParam;
import com.elitesland.external.cpcn.core.param.ImageInfoParam;
import com.elitesland.external.cpcn.core.param.ShareholderPartParam;
import com.elitesland.external.cpcn.core.utils.CPCNConvert;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import org.springframework.stereotype.Component;
import payment.api.vo.AttachInfo;
import payment.api.vo.ImageInfo;
import payment.api.vo.ShareholderPart;

@Component
public class CPCNConvertImpl
implements CPCNConvert {
    @Override
    public ArrayList<AttachInfo> getAttachInfos(ArrayList<AttachInfoParam> params) {
        if (params == null) {
            return null;
        }
        ArrayList<AttachInfo> arrayList = new ArrayList<AttachInfo>();
        for (AttachInfoParam attachInfoParam : params) {
            arrayList.add(this.attachInfoParamToAttachInfo(attachInfoParam));
        }
        return arrayList;
    }

    @Override
    public ArrayList<ImageInfo> getImageInfos(ArrayList<ImageInfoParam> params) {
        if (params == null) {
            return null;
        }
        ArrayList<ImageInfo> arrayList = new ArrayList<ImageInfo>();
        for (ImageInfoParam imageInfoParam : params) {
            arrayList.add(this.imageInfoParamToImageInfo(imageInfoParam));
        }
        return arrayList;
    }

    @Override
    public ArrayList<ShareholderPart> getShareholderParts(ArrayList<ShareholderPartParam> params) {
        if (params == null) {
            return null;
        }
        ArrayList<ShareholderPart> arrayList = new ArrayList<ShareholderPart>();
        for (ShareholderPartParam shareholderPartParam : params) {
            arrayList.add(this.shareholderPartParamToShareholderPart(shareholderPartParam));
        }
        return arrayList;
    }

    protected AttachInfo attachInfoParamToAttachInfo(AttachInfoParam attachInfoParam) {
        if (attachInfoParam == null) {
            return null;
        }
        AttachInfo attachInfo = new AttachInfo();
        attachInfo.setPayType(attachInfoParam.getPayType());
        attachInfo.setAppID(attachInfoParam.getAppID());
        attachInfo.setAuthPath(attachInfoParam.getAuthPath());
        return attachInfo;
    }

    protected ImageInfo imageInfoParamToImageInfo(ImageInfoParam imageInfoParam) {
        if (imageInfoParam == null) {
            return null;
        }
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setImageInfo(imageInfoParam.getImageInfo());
        imageInfo.setImageType(imageInfoParam.getImageType());
        imageInfo.setImageContent(imageInfoParam.getImageContent());
        return imageInfo;
    }

    protected ShareholderPart shareholderPartParamToShareholderPart(ShareholderPartParam shareholderPartParam) {
        if (shareholderPartParam == null) {
            return null;
        }
        ShareholderPart shareholderPart = new ShareholderPart();
        shareholderPart.setShareholderName(shareholderPartParam.getShareholderName());
        shareholderPart.setShCredentialType(shareholderPartParam.getShCredentialType());
        shareholderPart.setShCredentialNumber(shareholderPartParam.getShCredentialNumber());
        if (shareholderPartParam.getShPersonIssDate() != null) {
            shareholderPart.setShPersonIssDate(DateTimeFormatter.ISO_LOCAL_DATE.format(shareholderPartParam.getShPersonIssDate()));
        }
        shareholderPart.setShPersonExpiryDate(shareholderPartParam.getShPersonExpiryDate());
        return shareholderPart;
    }
}

