/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.external.cpcn.core.utils;

import com.elitesland.external.cpcn.core.param.CPCN2734Param;
import com.elitesland.external.cpcn.core.param.CPCN4600Param;
import com.elitesland.external.cpcn.core.param.CPCN4601Param;
import com.elitesland.external.cpcn.core.param.CPCN4611Param;
import com.elitesland.external.cpcn.core.param.CPCN4613Param;
import com.elitesland.external.cpcn.core.param.CPCN4616Param;
import com.elitesland.external.cpcn.core.param.CPCN7703Param;
import com.elitesland.external.cpcn.core.resp.CPCN2734Resp;
import com.elitesland.external.cpcn.core.resp.CPCN2735Resp;
import com.elitesland.external.cpcn.core.resp.CPCN4600Resp;
import com.elitesland.external.cpcn.core.resp.CPCN4601Resp;
import com.elitesland.external.cpcn.core.resp.CPCN4611Resp;
import com.elitesland.external.cpcn.core.resp.CPCN4613Resp;
import com.elitesland.external.cpcn.core.resp.CPCN4616Resp;
import com.elitesland.external.cpcn.core.resp.CPCN7703Resp;
import com.elitesland.external.cpcn.core.resp.CPCN7704Resp;
import com.elitesland.external.cpcn.core.utils.CPCNConvert;
import com.elitesland.external.cpcn.core.utils.CPCNUtils;
import cpcn.institution.tools.util.StringUtil;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import payment.api.system.PaymentEnvironment;
import payment.api.tx.TxBaseRequest;
import payment.api.tx.enrollment.Tx7703Request;
import payment.api.tx.enrollment.Tx7703Response;
import payment.api.tx.enrollment.Tx7704Request;
import payment.api.tx.enrollment.Tx7704Response;
import payment.api.tx.foundationaccount.Tx4601Request;
import payment.api.tx.foundationaccount.Tx4601Response;
import payment.api.tx.foundationaccount.Tx4611Request;
import payment.api.tx.foundationaccount.Tx4611Response;
import payment.api.tx.foundationaccount.Tx4613Request;
import payment.api.tx.foundationaccount.Tx4613Response;
import payment.api.tx.foundationaccount.Tx4616Request;
import payment.api.tx.foundationaccount.Tx4616Response;
import payment.api.tx.gatheringaccredit.Tx2734Request;
import payment.api.tx.gatheringaccredit.Tx2734Response;
import payment.api.tx.gatheringaccredit.Tx2735Request;
import payment.api.tx.gatheringaccredit.Tx2735Response;
import payment.api.tx.payroll.Tx4600Request;
import payment.api.tx.payroll.Tx4600Response;
import payment.api.util.GUIDGenerator;
import payment.api.vo.AttachInfo;
import payment.api.vo.ImageInfo;
import payment.api.vo.ShareholderPart;

public class CPCNTxCodeRequest {
    private static final Logger log = LoggerFactory.getLogger(CPCNTxCodeRequest.class);

    public static CPCN2734Resp cpcn2734Request(CPCN2734Param param) {
        Tx2734Response response;
        Tx2734Request req = new Tx2734Request();
        if (StringUtil.isNotEmpty((String)PaymentEnvironment.institutionID)) {
            req.setInstitutionID(PaymentEnvironment.institutionID);
        }
        if (StringUtil.isNotEmpty((String)param.getApplyNo())) {
            req.setApplyNo(param.getApplyNo());
        }
        if (StringUtil.isNotEmpty((String)param.getUserID())) {
            req.setUserID(param.getUserID());
        }
        if (StringUtil.isNotEmpty((String)param.getPayWay())) {
            req.setPayWay(param.getPayWay());
        }
        if (StringUtil.isNotEmpty((String)param.getCategory())) {
            req.setCategory(param.getCategory());
        }
        if (StringUtil.isNotEmpty((String)param.getServicePhone())) {
            req.setServicePhone(param.getServicePhone());
        }
        if (StringUtil.isNotEmpty((String)param.getPlatformName())) {
            req.setPlatformName(param.getPlatformName());
        }
        if (!CollectionUtils.isEmpty(param.getAttachInfoList())) {
            ArrayList<AttachInfo> attachInfos = CPCNConvert.INSTANCE.getAttachInfos(param.getAttachInfoList());
            req.setAttachInfoList(attachInfos);
        }
        if (!CPCNUtils.SUCCESS_CODE.equals((response = (Tx2734Response)CPCNUtils.send((TxBaseRequest)req)).getCode())) {
            log.info("\u54cd\u5e94\u5931\u8d25\uff0c\u54cd\u5e94\u7801:{}", (Object)response.getCode());
        }
        log.info("\u4e2d\u91d1\u652f\u4ed8\u54cd\u5e94\u7684\u62a5\u6587: \n" + response.getResponsePlainText() + "\n");
        CPCN2734Resp cpcn2734Resp = new CPCN2734Resp();
        BeanUtils.copyProperties((Object)response, (Object)cpcn2734Resp);
        log.info("\u8f6c\u6362\u540e\u7684\u5bf9\u8c61:{}", (Object)cpcn2734Resp);
        return cpcn2734Resp;
    }

    public static CPCN2735Resp cpcn2735Request(String applyNo) {
        Tx2735Response response;
        Tx2735Request req = new Tx2735Request();
        if (StringUtil.isNotEmpty((String)PaymentEnvironment.institutionID)) {
            req.setInstitutionID(PaymentEnvironment.institutionID);
        }
        if (StringUtil.isNotEmpty((String)applyNo)) {
            req.setApplyNo(applyNo);
        }
        if (!CPCNUtils.SUCCESS_CODE.equals((response = (Tx2735Response)CPCNUtils.send((TxBaseRequest)req)).getCode())) {
            log.info("\u54cd\u5e94\u5931\u8d25\uff0c\u54cd\u5e94\u7801:{}", (Object)response.getCode());
        }
        log.info("\u4e2d\u91d1\u652f\u4ed8\u54cd\u5e94\u7684\u62a5\u6587: \n" + response.getResponsePlainText() + "\n");
        CPCN2735Resp cpcn2735Resp = new CPCN2735Resp();
        BeanUtils.copyProperties((Object)response, (Object)cpcn2735Resp);
        log.info("\u8f6c\u6362\u540e\u7684\u5bf9\u8c61:{}", (Object)cpcn2735Resp);
        return cpcn2735Resp;
    }

    public static CPCN4600Resp cpcn4600Request(CPCN4600Param param) {
        Tx4600Response response;
        Tx4600Request req = new Tx4600Request();
        if (StringUtil.isNotEmpty((String)PaymentEnvironment.institutionID)) {
            req.setInstitutionID(PaymentEnvironment.institutionID);
        }
        if (StringUtil.isNotEmpty((String)param.getTxSN())) {
            req.setTxSN(param.getTxSN());
        }
        if (StringUtil.isNotEmpty((String)param.getBusinessType())) {
            req.setBusinessType(param.getBusinessType());
        }
        if (StringUtil.isNotEmpty((String)param.getUserType())) {
            req.setUserType(param.getUserType());
        }
        if (StringUtil.isNotEmpty((String)param.getUserID())) {
            req.setUserID(param.getUserID());
        }
        if (!CollectionUtils.isEmpty(param.getImageInfoList())) {
            ArrayList<ImageInfo> imageInfos = CPCNConvert.INSTANCE.getImageInfos(param.getImageInfoList());
            req.setImageInfoList(imageInfos);
        }
        if (!CPCNUtils.SUCCESS_CODE.equals((response = (Tx4600Response)CPCNUtils.send((TxBaseRequest)req)).getCode())) {
            log.info("\u54cd\u5e94\u5931\u8d25\uff0c\u54cd\u5e94\u7801:{}", (Object)response.getCode());
        }
        log.info("\u4e2d\u91d1\u652f\u4ed8\u54cd\u5e94\u7684\u62a5\u6587: \n" + response.getResponsePlainText() + "\n");
        CPCN4600Resp cpcn4600Resp = new CPCN4600Resp();
        BeanUtils.copyProperties((Object)response, (Object)cpcn4600Resp);
        log.info("\u8f6c\u6362\u540e\u7684\u5bf9\u8c61:{}", (Object)cpcn4600Resp);
        return cpcn4600Resp;
    }

    public static CPCN4601Resp cpcn4601Request(CPCN4601Param param) {
        Tx4601Response response;
        Tx4601Request req = new Tx4601Request();
        if (StringUtil.isNotEmpty((String)PaymentEnvironment.institutionID)) {
            req.setInstitutionID(PaymentEnvironment.institutionID);
        }
        if (StringUtil.isNotEmpty((String)param.getTxSN())) {
            req.setTxSN(param.getTxSN());
        }
        if (StringUtil.isNotEmpty((String)param.getUserID())) {
            req.setUserID(param.getUserID());
        }
        if (StringUtil.isNotEmpty((String)param.getParentUserID())) {
            req.setParentUserID(param.getParentUserID());
        }
        if (StringUtil.isNotEmpty((String)param.getUserType())) {
            req.setUserType(param.getUserType());
        }
        if (StringUtil.isNotEmpty((String)param.getAcceptanceConfirmType())) {
            req.setAcceptanceConfirmType(param.getAcceptanceConfirmType());
        }
        if (StringUtil.isNotEmpty((String)param.getAccountLevel())) {
            req.setAccountLevel(param.getAccountLevel());
        }
        if (StringUtil.isNotEmpty((String)param.getImageCollectionTxSN())) {
            req.setImageCollectionTxSN(param.getImageCollectionTxSN());
        }
        if (StringUtil.isNotEmpty((String)param.getNoticeURL())) {
            req.setNoticeURL(param.getNoticeURL());
        }
        if (StringUtil.isNotEmpty((String)param.getPhoneNumber())) {
            req.setPhoneNumber(param.getPhoneNumber());
        }
        if (StringUtil.isNotEmpty((String)param.getUserName())) {
            req.setUserName(param.getUserName());
        }
        if (StringUtil.isNotEmpty((String)param.getCredentialType())) {
            req.setCredentialType(param.getCredentialType());
        }
        if (StringUtil.isNotEmpty((String)param.getCredentialNumber())) {
            req.setCredentialNumber(param.getCredentialNumber());
        }
        if (!Objects.isNull(param.getIssDate())) {
            req.setIssDate(param.getIssDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        if (!Objects.isNull(param.getExpiryDate())) {
            req.setExpiryDate(param.getExpiryDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        if (StringUtil.isNotEmpty((String)param.getIndAddress())) {
            req.setIndAddress(param.getIndAddress());
        }
        if (StringUtil.isNotEmpty((String)param.getIndEmail())) {
            req.setIndEmail(param.getIndEmail());
        }
        if (StringUtil.isNotEmpty((String)param.getCredentialAddress())) {
            req.setCredentialAddress(param.getCredentialAddress());
        }
        if (StringUtil.isNotEmpty((String)param.getOccupation())) {
            req.setOccupation(param.getOccupation());
        }
        if (StringUtil.isNotEmpty((String)param.getCorporationName())) {
            req.setCorporationName(param.getCorporationName());
        }
        if (StringUtil.isNotEmpty((String)param.getCorporationShort())) {
            req.setCorporationShort(param.getCorporationShort());
        }
        if (StringUtil.isNotEmpty((String)param.getCategoryType())) {
            req.setCategoryType(param.getCategoryType());
        }
        if (StringUtil.isNotEmpty((String)param.getCorEmail())) {
            req.setCorEmail(param.getCorEmail());
        }
        if (StringUtil.isNotEmpty((String)param.getCorAddress())) {
            req.setCorAddress(param.getCorAddress());
        }
        if (StringUtil.isNotEmpty((String)param.getProvince())) {
            req.setProvince(param.getProvince());
        }
        if (StringUtil.isNotEmpty((String)param.getCity())) {
            req.setCity(param.getCity());
        }
        if (StringUtil.isNotEmpty((String)param.getDistrict())) {
            req.setDistrict(param.getDistrict());
        }
        if (StringUtil.isNotEmpty((String)param.getIndustryBelongType())) {
            req.setIndustryBelongType(param.getIndustryBelongType());
        }
        if (StringUtil.isNotEmpty((String)param.getIndustry())) {
            req.setIndustry(param.getIndustry());
        }
        if (StringUtil.isNotEmpty((String)param.getScale())) {
            req.setScale(param.getScale());
        }
        if (StringUtil.isNotEmpty((String)param.getBasicAcctNo())) {
            req.setBasicAcctNo(param.getBasicAcctNo());
        }
        if (StringUtil.isNotEmpty((String)param.getApprovalNo())) {
            req.setApprovalNo(param.getApprovalNo());
        }
        if (param.getAuthCapital().compareTo(null) != 0) {
            req.setAuthCapital(param.getAuthCapital().multiply(BigDecimal.valueOf(10000000L)).toString());
        }
        if (StringUtil.isNotEmpty((String)param.getBusinessScope())) {
            req.setBusinessScope(param.getBusinessScope());
        }
        if (StringUtil.isNotEmpty((String)param.getCorType())) {
            req.setCorType(param.getCorType());
        }
        if (StringUtil.isNotEmpty((String)param.getUnifiedSocialCreditCode())) {
            req.setUnifiedSocialCreditCode(param.getUnifiedSocialCreditCode());
        }
        if (!Objects.isNull(param.getAllLicenceIssDate())) {
            req.setAllLicenceExpiryDate(param.getAllLicenceExpiryDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        if (!Objects.isNull(param.getAllLicenceExpiryDate())) {
            req.setAllLicenceExpiryDate(param.getAllLicenceExpiryDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        if (StringUtil.isNotEmpty((String)param.getLegalPersonName())) {
            req.setLegalPersonName(param.getLegalPersonName());
        }
        if (StringUtil.isNotEmpty((String)param.getLegalCredentialType())) {
            req.setLegalCredentialType(param.getLegalCredentialType());
        }
        if (StringUtil.isNotEmpty((String)param.getLegalCredentialNumber())) {
            req.setLegalCredentialNumber(param.getLegalCredentialNumber());
        }
        if (!Objects.isNull(param.getLegalPersonIssDate())) {
            req.setLegalPersonIssDate(param.getLegalPersonIssDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        if (!Objects.isNull(param.getLegalPersonExpiryDate())) {
            req.setLegalPersonExpiryDate(param.getLegalPersonExpiryDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        if (StringUtil.isNotEmpty((String)param.getLegalPersonContactNumber())) {
            req.setLegalCredentialNumber(param.getLegalCredentialNumber());
        }
        if (StringUtil.isNotEmpty((String)param.getLegalPersonEmail())) {
            req.setLegalPersonEmail(param.getLegalPersonEmail());
        }
        if (StringUtil.isNotEmpty((String)param.getShareholder())) {
            req.setShareholder(param.getShareholder());
        }
        if (StringUtil.isNotEmpty((String)param.getController())) {
            req.setController(param.getController());
        }
        if (StringUtil.isNotEmpty((String)param.getBeneficiary())) {
            req.setBeneficiary(param.getBeneficiary());
        }
        if (!CollectionUtils.isEmpty(param.getShareholderPartsList())) {
            ArrayList<ShareholderPart> shareholderParts = CPCNConvert.INSTANCE.getShareholderParts(param.getShareholderPartsList());
            req.setShareholderPartsList(shareholderParts);
        }
        if (StringUtil.isNotEmpty((String)param.getManagerName())) {
            req.setManagerName(param.getManagerName());
        }
        if (StringUtil.isNotEmpty((String)param.getManagerCredentialType())) {
            req.setManagerCredentialType(param.getManagerCredentialType());
        }
        if (StringUtil.isNotEmpty((String)param.getManagerCredentialNumber())) {
            req.setManagerCredentialNumber(param.getManagerCredentialNumber());
        }
        if (!Objects.isNull(param.getManagerIssDate())) {
            req.setManagerIssDate(param.getManagerIssDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        if (!Objects.isNull(param.getManagerExpiryDate())) {
            req.setManagerExpiryDate(param.getManagerExpiryDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        if (StringUtil.isNotEmpty((String)param.getManagerContactNumber())) {
            req.setManagerContactNumber(param.getManagerContactNumber());
        }
        if (StringUtil.isNotEmpty((String)param.getManagerEmail())) {
            req.setManagerEmail(param.getManagerEmail());
        }
        if (StringUtil.isNotEmpty((String)param.getManagerCredentialAddress())) {
            req.setManagerCredentialAddress(param.getManagerCredentialAddress());
        }
        if (StringUtil.isNotEmpty((String)param.getManagerOccupation())) {
            req.setManagerOccupation(param.getManagerOccupation());
        }
        if (StringUtil.isNotEmpty((String)param.getRetailerRegNumber())) {
            req.setRetailerRegNumber(param.getRetailerRegNumber());
        }
        if (StringUtil.isNotEmpty((String)param.getRetailerName())) {
            req.setRetailerName(param.getRetailerName());
        }
        if (StringUtil.isNotEmpty((String)param.getRetailerLicenseIssDate())) {
            req.setRetailerLicenseExpiryDate(param.getRetailerLicenseExpiryDate());
        }
        if (StringUtil.isNotEmpty((String)param.getRetailerLicenseExpiryDate())) {
            req.setRetailerLicenseExpiryDate(param.getRetailerLicenseExpiryDate());
        }
        if (StringUtil.isNotEmpty((String)param.getRetailerFormation())) {
            req.setRetailerFormation(param.getRetailerFormation());
        }
        if (StringUtil.isNotEmpty((String)param.getRetailerAddress())) {
            req.setRetailerAddress(param.getRetailerAddress());
        }
        if (StringUtil.isNotEmpty((String)param.getRetailerProvince())) {
            req.setRetailerProvince(param.getRetailerProvince());
        }
        if (StringUtil.isNotEmpty((String)param.getRetailerCity())) {
            req.setRetailerCity(param.getRetailerCity());
        }
        if (StringUtil.isNotEmpty((String)param.getRetailerDistrict())) {
            req.setRetailerDistrict(param.getRetailerDistrict());
        }
        if (StringUtil.isNotEmpty((String)param.getRetailerBusinessScope())) {
            req.setRetailerBusinessScope(param.getRetailerBusinessScope());
        }
        if (StringUtil.isNotEmpty((String)param.getBindingTxSN())) {
            req.setBindingTxSN(param.getBindingTxSN());
        }
        if (StringUtil.isNotEmpty((String)param.getBankID())) {
            req.setBankID(param.getBankID());
        }
        if (StringUtil.isNotEmpty((String)param.getBankAccountNumber())) {
            req.setBankAccountNumber(param.getBankAccountNumber());
        }
        if (StringUtil.isNotEmpty((String)param.getBankPhoneNumber())) {
            req.setBankPhoneNumber(param.getBankPhoneNumber());
        }
        if (StringUtil.isNotEmpty((String)param.getCNAPSCode())) {
            req.setCNAPSCode(param.getCNAPSCode());
        }
        if (StringUtil.isNotEmpty((String)param.getBranchName())) {
            req.setBranchName(param.getBranchName());
        }
        if (StringUtil.isNotEmpty((String)param.getBankProvince())) {
            req.setBankProvince(param.getBankProvince());
        }
        if (StringUtil.isNotEmpty((String)param.getBankCity())) {
            req.setBankCity(param.getBankCity());
        }
        if (!CPCNUtils.SUCCESS_CODE.equals((response = (Tx4601Response)CPCNUtils.send((TxBaseRequest)req)).getCode())) {
            log.info("\u54cd\u5e94\u5931\u8d25\uff0c\u54cd\u5e94\u7801:{}", (Object)response.getCode());
        }
        log.info("\u4e2d\u91d1\u652f\u4ed8\u54cd\u5e94\u7684\u62a5\u6587: \n" + response.getResponsePlainText() + "\n");
        CPCN4601Resp cpcn4601Resp = new CPCN4601Resp();
        BeanUtils.copyProperties((Object)response, (Object)cpcn4601Resp);
        log.info("\u8f6c\u6362\u540e\u7684\u5bf9\u8c61:{}", (Object)cpcn4601Resp);
        return cpcn4601Resp;
    }

    public static CPCN4611Resp cpcn4611Request(CPCN4611Param param) {
        Tx4611Response response;
        Tx4611Request req = new Tx4611Request();
        if (StringUtil.isNotEmpty((String)PaymentEnvironment.institutionID)) {
            req.setInstitutionID(PaymentEnvironment.institutionID);
        }
        if (StringUtil.isNotEmpty((String)param.getBindingTxSN())) {
            req.setBindingTxSN(param.getBindingTxSN());
        }
        if (StringUtil.isNotEmpty((String)param.getUserID())) {
            req.setUserID(param.getUserID());
        }
        if (StringUtil.isNotEmpty((String)param.getPayeeUserID())) {
            req.setPayeeUserID(param.getPayeeUserID());
        }
        if (StringUtil.isNotEmpty((String)param.getAcceptanceConfirmType())) {
            req.setAcceptanceConfirmType(param.getAcceptanceConfirmType());
        }
        if (StringUtil.isNotEmpty((String)param.getBankCardType())) {
            req.setBankCardType(param.getBankCardType());
        }
        if (StringUtil.isNotEmpty((String)param.getOperationFlag())) {
            req.setOperationFlag(param.getOperationFlag());
        }
        if (StringUtil.isNotEmpty((String)param.getBankAccountType())) {
            req.setBankAccountType(param.getBankAccountType());
        }
        if (StringUtil.isNotEmpty((String)param.getUpgradeTxSN())) {
            req.setUpgradeTxSN(param.getUpgradeTxSN());
        }
        if (StringUtil.isNotEmpty((String)param.getBindingWay())) {
            req.setBindingWay(param.getBindingWay());
        }
        if (StringUtil.isNotEmpty((String)param.getCredentialType())) {
            req.setCredentialType(param.getCredentialType());
        }
        if (StringUtil.isNotEmpty((String)param.getCredentialNumber())) {
            req.setCredentialNumber(param.getCredentialNumber());
        }
        if (StringUtil.isNotEmpty((String)param.getBankID())) {
            req.setBankID(param.getBankID());
        }
        if (StringUtil.isNotEmpty((String)param.getBankAccountType())) {
            req.setBankAccountType(param.getBankAccountType());
        }
        if (StringUtil.isNotEmpty((String)param.getBankAccountName())) {
            req.setBankAccountName(param.getBankAccountName());
        }
        if (StringUtil.isNotEmpty((String)param.getBankAccountNumber())) {
            req.setBankAccountNumber(param.getBankAccountNumber());
        }
        if (StringUtil.isNotEmpty((String)param.getBankPhoneNumber())) {
            req.setBankPhoneNumber(param.getBankPhoneNumber());
        }
        if (StringUtil.isNotEmpty((String)param.getBranchName())) {
            req.setBranchName(param.getBranchName());
        }
        if (StringUtil.isNotEmpty((String)param.getCNAPSCode())) {
            req.setCNAPSCode(param.getCNAPSCode());
        }
        if (StringUtil.isNotEmpty((String)param.getProvince())) {
            req.setProvince(param.getProvince());
        }
        if (StringUtil.isNotEmpty((String)param.getCity())) {
            req.setCity(param.getCity());
        }
        if (!Objects.isNull(param.getValidDate())) {
            req.setValidDate(param.getValidDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        if (StringUtil.isNotEmpty((String)param.getCVN2())) {
            req.setCVN2(param.getCVN2());
        }
        if (StringUtil.isNotEmpty((String)param.getTransferChargeFlag())) {
            req.setTransferChargeFlag(param.getTransferChargeFlag());
        }
        if (StringUtil.isNotEmpty((String)param.getNoticeURL())) {
            req.setNoticeURL(param.getNoticeURL());
        }
        if (StringUtil.isNotEmpty((String)param.getPageURL())) {
            req.setPageURL(param.getPageURL());
        }
        if (!CPCNUtils.SUCCESS_CODE.equals((response = (Tx4611Response)CPCNUtils.send((TxBaseRequest)req)).getCode())) {
            log.info("\u54cd\u5e94\u5931\u8d25\uff0c\u54cd\u5e94\u7801:{}", (Object)response.getCode());
        }
        log.info("\u4e2d\u91d1\u652f\u4ed8\u54cd\u5e94\u7684\u62a5\u6587: \n" + response.getResponsePlainText() + "\n");
        CPCN4611Resp cpcn4611Resp = new CPCN4611Resp();
        BeanUtils.copyProperties((Object)response, (Object)cpcn4611Resp);
        log.info("\u8f6c\u6362\u540e\u7684\u5bf9\u8c61:{}", (Object)cpcn4611Resp);
        return cpcn4611Resp;
    }

    public static CPCN4613Resp cpcn4613Request(CPCN4613Param param) {
        Tx4613Response response;
        Tx4613Request req = new Tx4613Request();
        if (StringUtil.isNotEmpty((String)PaymentEnvironment.institutionID)) {
            req.setInstitutionID(PaymentEnvironment.institutionID);
        }
        if (StringUtil.isNotEmpty((String)param.getTxSN())) {
            req.setTxSN(param.getTxSN());
        }
        if (StringUtil.isNotEmpty((String)param.getVerifyWay())) {
            req.setVerifyWay(param.getVerifyWay());
        }
        if (StringUtil.isNotEmpty((String)param.getSMSCode())) {
            req.setSMSCode(param.getSMSCode());
        }
        if (StringUtil.isNotEmpty((String)param.getCVN2())) {
            req.setCVN2(param.getCVN2());
        }
        if (!Objects.isNull(param.getValidDate())) {
            req.setValidDate(param.getValidDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        if (param.getAmount().compareTo(null) != 0) {
            req.setAmount(param.getAmount().multiply(BigDecimal.valueOf(100L)).toString());
        }
        if (!CPCNUtils.SUCCESS_CODE.equals((response = (Tx4613Response)CPCNUtils.send((TxBaseRequest)req)).getCode())) {
            log.info("\u54cd\u5e94\u5931\u8d25\uff0c\u54cd\u5e94\u7801:{}", (Object)response.getCode());
        }
        log.info("\u4e2d\u91d1\u652f\u4ed8\u54cd\u5e94\u7684\u62a5\u6587: \n" + response.getResponsePlainText() + "\n");
        CPCN4613Resp cpcn4613Resp = new CPCN4613Resp();
        BeanUtils.copyProperties((Object)response, (Object)cpcn4613Resp);
        log.info("\u8f6c\u6362\u540e\u7684\u5bf9\u8c61:{}", (Object)cpcn4613Resp);
        return cpcn4613Resp;
    }

    public static CPCN4616Resp cpcn4616Request(CPCN4616Param param) {
        Tx4616Response response;
        Tx4616Request req = new Tx4616Request();
        if (StringUtil.isNotEmpty((String)PaymentEnvironment.institutionID)) {
            req.setInstitutionID(PaymentEnvironment.institutionID);
        }
        if (StringUtil.isNotEmpty((String)param.getSourceTxCode())) {
            req.setSourceTxCode(param.getSourceTxCode());
        }
        if (StringUtil.isNotEmpty((String)param.getSourceTxSN())) {
            req.setSourceTxCode(param.getSourceTxCode());
        }
        if (StringUtil.isNotEmpty((String)param.getUserType())) {
            req.setUserType(param.getUserType());
        }
        if (StringUtil.isNotEmpty((String)param.getOperationFlag())) {
            req.setOperationFlag(param.getOperationFlag());
        }
        if (!CPCNUtils.SUCCESS_CODE.equals((response = (Tx4616Response)CPCNUtils.send((TxBaseRequest)req)).getCode())) {
            log.info("\u54cd\u5e94\u5931\u8d25\uff0c\u54cd\u5e94\u7801:{}", (Object)response.getCode());
        }
        log.info("\u4e2d\u91d1\u652f\u4ed8\u54cd\u5e94\u7684\u62a5\u6587: \n" + response.getResponsePlainText() + "\n");
        CPCN4616Resp cpcn4616Resp = new CPCN4616Resp();
        BeanUtils.copyProperties((Object)response, (Object)cpcn4616Resp);
        log.info("\u8f6c\u6362\u540e\u7684\u5bf9\u8c61:{}", (Object)cpcn4616Resp);
        return cpcn4616Resp;
    }

    public static CPCN7703Resp cpcn7703Request(CPCN7703Param param) {
        Tx7703Response response;
        Tx7703Request req = new Tx7703Request();
        if (StringUtil.isNotEmpty((String)PaymentEnvironment.institutionID)) {
            req.setInstitutionID(PaymentEnvironment.institutionID);
        }
        if (StringUtil.isNotEmpty((String)param.getApplyNo())) {
            req.setApplyNo(param.getApplyNo());
        }
        if (StringUtil.isNotEmpty((String)param.getUserID())) {
            req.setUserID(param.getUserID());
        }
        if (StringUtil.isNotEmpty((String)param.getProtocolNumber())) {
            req.setProtocolNumber(param.getProtocolNumber());
        }
        if (StringUtil.isNotEmpty((String)param.getProtocolSignerType())) {
            req.setProtocolSignerType(param.getProtocolSignerType());
        }
        if (StringUtil.isNotEmpty((String)param.getAgentPhoneNumber())) {
            req.setAgentPhoneNumber(param.getAgentPhoneNumber());
        }
        if (StringUtil.isNotEmpty((String)param.getAgentName())) {
            req.setAgentName(param.getAgentName());
        }
        if (StringUtil.isNotEmpty((String)param.getAgentIDNumber())) {
            req.setAgentIDNumber(param.getAgentIDNumber());
        }
        if (StringUtil.isNotEmpty((String)param.getImmediatelySign())) {
            req.setImmediatelySign(param.getImmediatelySign());
        }
        if (!CPCNUtils.SUCCESS_CODE.equals((response = (Tx7703Response)CPCNUtils.send((TxBaseRequest)req)).getCode())) {
            log.info("\u54cd\u5e94\u5931\u8d25\uff0c\u54cd\u5e94\u7801:{}", (Object)response.getCode());
        }
        log.info("\u4e2d\u91d1\u652f\u4ed8\u54cd\u5e94\u7684\u62a5\u6587: \n" + response.getResponsePlainText() + "\n");
        CPCN7703Resp cpcn7703Resp = new CPCN7703Resp();
        BeanUtils.copyProperties((Object)response, (Object)cpcn7703Resp);
        log.info("\u8f6c\u6362\u540e\u7684\u5bf9\u8c61:{}", (Object)cpcn7703Resp);
        return cpcn7703Resp;
    }

    public static CPCN7704Resp cpcn7704Request(String applyNo) {
        Tx7704Response response;
        Tx7704Request req = new Tx7704Request();
        if (StringUtil.isNotEmpty((String)PaymentEnvironment.institutionID)) {
            req.setInstitutionID(PaymentEnvironment.institutionID);
        }
        if (StringUtil.isNotEmpty((String)applyNo)) {
            req.setApplyNo(applyNo);
        }
        if (!CPCNUtils.SUCCESS_CODE.equals((response = (Tx7704Response)CPCNUtils.send((TxBaseRequest)req)).getCode())) {
            log.info("\u54cd\u5e94\u5931\u8d25\uff0c\u54cd\u5e94\u7801:{}", (Object)response.getCode());
        }
        log.info("\u4e2d\u91d1\u652f\u4ed8\u54cd\u5e94\u7684\u62a5\u6587: \n" + response.getResponsePlainText() + "\n");
        CPCN7704Resp cpcn7704Resp = new CPCN7704Resp();
        BeanUtils.copyProperties((Object)response, (Object)cpcn7704Resp);
        log.info("\u8f6c\u6362\u540e\u7684\u5bf9\u8c61:{}", (Object)cpcn7704Resp);
        return cpcn7704Resp;
    }

    public static String getTxSN() {
        String txSN = null;
        try {
            txSN = GUIDGenerator.genGUID();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return txSN;
    }
}

