/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.external.cpcn.core.utils;

import cpcn.institution.tools.net.RequestDgtEnvlp;
import cpcn.institution.tools.util.Base64;
import cpcn.institution.tools.util.DigitalEnvelopeUtil;
import cpcn.institution.tools.util.StringUtil;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import payment.api.system.PaymentEnvironment;
import payment.api.system.TxMessenger;
import payment.api.tx.TxBaseRequest;
import payment.api.tx.TxBaseResponse;
import payment.api.tx.enrollment.Tx7703Response;
import payment.api.tx.enrollment.Tx7704Response;
import payment.api.tx.foundationaccount.Tx4601Response;
import payment.api.tx.foundationaccount.Tx4611Response;
import payment.api.tx.foundationaccount.Tx4613Response;
import payment.api.tx.foundationaccount.Tx4616Response;
import payment.api.tx.gatheringaccredit.Tx2734Response;
import payment.api.tx.gatheringaccredit.Tx2735Response;
import payment.api.tx.payroll.Tx4600Response;

public class CPCNUtils {
    private static Logger logger = LoggerFactory.getLogger(CPCNUtils.class);
    private static String clientIP = "127.0.0.1";
    protected static String SUCCESS_CODE = "2000";
    private static String CHINAGAS_PAYMENT_FILE = "/resources/main/payment";

    protected static TxBaseResponse send(TxBaseRequest baseRequest) {
        Tx4611Response txBaseResponse = null;
        try {
            baseRequest.process();
            String message = baseRequest.getRequestMessage();
            String signature = baseRequest.getRequestSignature();
            RequestDgtEnvlp requestDgtEnvlp = new RequestDgtEnvlp();
            requestDgtEnvlp.setDgtlEnvlp(baseRequest.getDgtlEnvlp());
            requestDgtEnvlp.setSignAlgorithm(baseRequest.getSignAlgorithm());
            requestDgtEnvlp.setSignSN(baseRequest.getSignSN());
            requestDgtEnvlp.setEncryptSN(baseRequest.getEncryptSN());
            requestDgtEnvlp.setInstitutionID(PaymentEnvironment.institutionID);
            requestDgtEnvlp.setIsDgEnv(PaymentEnvironment.isDgEnv);
            TxMessenger txMessenger = new TxMessenger();
            String[] respMsg = null;
            respMsg = txMessenger.send(message, signature, requestDgtEnvlp);
            if ("YES".equals(respMsg[2])) {
                try {
                    logger.info("\u5f00\u59cb\u5bf9\u54cd\u5e94\u6d88\u606f\u505a\u5bf9\u79f0\u89e3\u5bc6\u3002\u3002\u3002\u3002\u3002\u3002");
                    respMsg[0] = DigitalEnvelopeUtil.decryptResponse((String)respMsg[0], (String)respMsg[3], (String)respMsg[5], (String)respMsg[6]);
                    respMsg[0] = Base64.encode((String)respMsg[0], (String)"UTF-8");
                    respMsg[0] = respMsg[0] + "," + respMsg[5] + "," + respMsg[4] + "," + respMsg[2];
                    logger.info("\u54cd\u5e94\u6d88\u606f\u505a\u5bf9\u79f0\u89e3\u5bc6\u5b8c\u6210\u3002\u3002\u3002\u3002\u3002\u3002");
                }
                catch (Exception e) {
                    throw new Exception(e + "\u5bf9\u79f0\u89e3\u5bc6\u5f02\u5e38\uff01");
                }
            } else if (StringUtil.isNotEmpty((String)respMsg[5])) {
                respMsg[0] = respMsg[0] + "," + respMsg[5] + "," + respMsg[4] + "," + respMsg[2];
            }
            int txCode = Integer.parseInt(baseRequest.getTxCode());
            switch (txCode) {
                case 4611: {
                    txBaseResponse = new Tx4611Response(respMsg[0], respMsg[1]);
                    break;
                }
                case 4613: {
                    txBaseResponse = new Tx4613Response(respMsg[0], respMsg[1]);
                    break;
                }
                case 4616: {
                    txBaseResponse = new Tx4616Response(respMsg[0], respMsg[1]);
                    break;
                }
                case 4600: {
                    txBaseResponse = new Tx4600Response(respMsg[0], respMsg[1]);
                    break;
                }
                case 4601: {
                    txBaseResponse = new Tx4601Response(respMsg[0], respMsg[1]);
                    break;
                }
                case 7703: {
                    txBaseResponse = new Tx7703Response(respMsg[0], respMsg[1]);
                    break;
                }
                case 7704: {
                    txBaseResponse = new Tx7704Response(respMsg[0], respMsg[1]);
                    break;
                }
                case 2734: {
                    txBaseResponse = new Tx2734Response(respMsg[0], respMsg[1]);
                    break;
                }
                case 2735: {
                    txBaseResponse = new Tx2735Response(respMsg[0], respMsg[1]);
                    break;
                }
                default: {
                    logger.error("\u53cd\u56deresponse \u6ca1\u6709\u914d\u7f6e" + respMsg[0] + respMsg[1]);
                    logger.info("\u4e2d\u91d1\u652f\u4ed8\u63a5\u53e3\u4ea4\u4e92\uff0c\u8fd4\u56de response \u6ca1\u6709\u914d\u7f6e" + respMsg[0] + respMsg[1]);
                    break;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return txBaseResponse;
    }

    static {
        try {
            clientIP = InetAddress.getLocalHost().getHostAddress();
            PaymentEnvironment.initialize((String)CHINAGAS_PAYMENT_FILE);
            PaymentEnvironment.institutionID = "007087";
            PaymentEnvironment.isDgEnv = "YES";
            clientIP = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable t) {
            logger.error("\u521d\u59cb\u5316\u5931\u8d25\uff01" + t.getMessage(), t);
        }
    }
}

