package com.elitesland.fin.lm.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.lm.Application;
import com.elitesland.fin.lm.rpc.dto.flow.AccountFlowExtRpcDTO;
import com.elitesland.fin.lm.rpc.param.flow.AccountFlowExtRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/03/04
 * @Version 1.0
 * @Content:
 */
@Validated
@FeignClient(name = Application.NAME, path = AccountFlowExtRpcService.URI)
public interface AccountFlowExtRpcService {
    String URI = Application.URI_PREFIX + "/accountFlowExt";

    /**
     * 账户流水保存
     *
     * @param rpcParams 入参
     * @return 流水号
     */
    @PostMapping("/save")
    ApiResult<AccountFlowExtRpcDTO> save(@RequestBody List<AccountFlowExtRpcParam> rpcParams);

    /**
     * 根据来源单号进行发货红冲
     *
     * @param sourceNoList 来源单号
     * @return 账户流水返回对象
     */
    @PostMapping("/deliveryRedPunch")
    ApiResult<AccountFlowExtRpcDTO> deliveryRedPunch(@RequestBody List<String> sourceNoList);
}
