package com.elitesland.fin.lm.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.lm.Application;
import com.elitesland.fin.lm.rpc.dto.account.AccountExtRpcDTO;
import com.elitesland.fin.lm.rpc.dto.flow.AccountFlowExtRpcDTO;
import com.elitesland.fin.lm.rpc.param.account.AccountExtRpcParam;
import com.elitesland.fin.lm.rpc.param.account.AccountRpcParam;
import com.elitesland.fin.lm.rpc.param.account.UpdateAccountExtRpcParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.lm.rpc
 * @date 2023/3/7 15:36
 */

@Validated
@FeignClient(name = Application.NAME, path = AccountRpcService.URI)
public interface AccountRpcService {
    String URI = Application.URI_PREFIX + "/account";

    /**
     * 订单提交，校验账户金额接口（若通过，生成流水）
     *
     * @param accountExtRpcParam 入参
     * @return 流水号
     */
    @PostMapping("/checkAcc")
    ApiResult<AccountExtRpcDTO> checkAcc(@RequestBody AccountExtRpcParam accountExtRpcParam);


    /**
     * 订单修改，释放原订单占用，重新校验账户金额接口（若通过，生成流水）
     *
     * @param updateAccountExtRpcParam 入参
     * @return 流水号
     */
    @PostMapping("/updateOrderAmtAndCheckAcc")
    ApiResult<AccountExtRpcDTO> updateOrderAmtAndCheckAcc(@RequestBody UpdateAccountExtRpcParam updateAccountExtRpcParam);


    /**
     * 自动创建账户
     *
     * @param accountRpcParamList
     * @return
     */
    @PostMapping("saveAcc")
    ApiResult<Boolean> saveAcc(@RequestBody List<AccountRpcParam> accountRpcParamList);


    /**
     * 修改根据客户编码修改客户名称/客户简称/客户号 接口
     *
     * @param accountRpcParam
     * @return
     */
    @PostMapping("updateAcc")
    ApiResult<Boolean> updateAcc(@RequestBody AccountRpcParam accountRpcParam);


    /**
     * 根据  销售公司  订单类型   客户  开票客户 查询储值账户编码/名称
     * @param accountExtRpcParam
     * @return
     */
    @PostMapping("findAccByParam")
    ApiResult<AccountExtRpcDTO> findAccByParam(@RequestBody AccountExtRpcParam accountExtRpcParam);


    /**
     * 根据订单金额，客户信息，订单日期 查找对应的账户余额统计
     * @param accountExtRpcParam
     * @return
     */
    @PostMapping("getAmtByDealerCode")
    ApiResult<AccountExtRpcDTO> getAmtByDealerCode(@RequestBody AccountExtRpcParam accountExtRpcParam);

    /**
     * 客户信息，订单日期 查找对应的账户余额统计 返利金额取全部余额 不计算乘以90%
     * @param accountExtRpcParam
     * @return
     */
    @PostMapping("getByDealerCodeAndTime")
    ApiResult<AccountExtRpcDTO> getByDealerCodeAndTime(@RequestBody AccountExtRpcParam accountExtRpcParam);
}
