package com.elitesland.fin.lm.rpc.param.account;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.lm.rpc.param.account
 * @date 2023/3/7 14:35
 */
@Data
public class AccountExtRpcParam implements Serializable {

    @ApiModelProperty("开票方客户编码")
    private String invCode;

    @ApiModelProperty("订单类型 ZCZH整车账户,PJZH配件账户 ,FJZH附件账户")
    private String orderType;

    @ApiModelProperty("订单金额")
    private BigDecimal orderAmt;

    @ApiModelProperty("订单日期")
    private LocalDateTime orderTime;

    @ApiModelProperty("客户编码")
    private String dealerCode;
    @ApiModelProperty("开票客户编码")
    private String billtoCustCode;
    @ApiModelProperty("订单号码")
    private String orderNo;

    @ApiModelProperty("储值金额")
    private BigDecimal ccAmt;

    @ApiModelProperty("返利金额")
    private BigDecimal flAmt;

    /**
     * 是否修改订单
     */
    private Boolean update;

    @ApiModelProperty("订单备注")
    private String remark;

    @ApiModelProperty("公司编码")
    private String ouCode;

    private String accType;

}
