package com.elitesland.fin.lm.rpc.param.flow;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/03/04
 * @Version 1.0
 * @Content:
 */
@Data
public class AccountFlowExtRpcParam implements Serializable {

    private static final long serialVersionUID = -4064238062431836363L;

    @ApiModelProperty("账户类型")
    private String accType;

    @ApiModelProperty("数据来源")
    private String dataSource;

    @ApiModelProperty("交易类型")
    private String transactionType;

    @ApiModelProperty("发生金额")
    private BigDecimal amount;

    @ApiModelProperty("交易日期")
    private LocalDateTime transactionTime;

    @ApiModelProperty("账户编码")
    private String accCode;

    @ApiModelProperty("账户名称")
    private String accName;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源单据")
    private String sourceDoc;

    @ApiModelProperty("来源平台")
    private String sourcePlatform;


    @ApiModelProperty("客户id")
    private Long dealerId;

    @ApiModelProperty("客户编码")
    private String dealerCode;

    @ApiModelProperty("客户名称")
    private String dealerName;

    @ApiModelProperty("客户客户号")
    private String dealerCustNo;

    @ApiModelProperty("客户简称")
    private String dealerAbbr;

}
