package com.elitesland.fin.application.convert.arorder;


import com.elitesland.fin.application.facade.param.arorder.ArOrderSaveParam;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderVO;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.entity.arorder.ArOrderDO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.param.arorder.ArOrderRpcParam;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @date 2022/3/16 16:14
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface ArOrderConvert {

    ArOrderConvert INSTANCE = Mappers.getMapper(ArOrderConvert.class);

    List<ArOrderVO> convertList(List<ArOrderDTO> arOrderDTOS);

    PagingVO<ArOrderVO> convertPage(PagingVO<ArOrderDTO> param);

    @Mapping(source = "arOrderDtlDTOList", target = "dtlList")
    ArOrderVO convert(ArOrderDTO arOrderDTO);

    ArOrderDO convert(ArOrder apOrder);

    @Mapping(source = "arOrderDtlParamList", target = "dtlList")
    ArOrder convert(ArOrderSaveParam arOrderSaveParam);

    @Mapping(source = "arOrderDtlRpcDTOList", target = "dtlList")
    ArOrder convertRpc(ArOrderRpcParam arOrderRpcParam);
}
