package com.elitesland.fin.application.convert.inputinv;

import com.elitesland.fin.application.facade.param.inputInv.InputInvSaveParam;
import com.elitesland.fin.application.facade.vo.inputinv.InputInvVO;
import com.elitesland.fin.domain.entity.inputinv.InputInv;
import com.elitesland.fin.domain.entity.inputinv.InputInvDO;
import com.elitesland.fin.infr.dto.inputinv.InputInvDTO;
import com.elitesland.fin.param.inputinv.InputInvRpcParam;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

/**
 * @author zhiyu.he
 * @date 2022/5/6 13:12
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface InputInvConvert {
    InputInvConvert INSTANCE = Mappers.getMapper(InputInvConvert.class);

    PagingVO<InputInvVO> convertPage(PagingVO<InputInvDTO> inputInvDTOPagingVO);

    @Mapping(source = "saveParamList", target = "dtlList")
    InputInv convertParam(InputInvSaveParam param);

    InputInvDO convertToDo(InputInv payOrder);
    
    @Mapping(target = "dtlVOList", source = "dtlDTOList")
    InputInvVO dtoToVo(InputInvDTO dto);

    @Mapping(target = "dtlList", source = "inputInvDtlRpcDTOList")
    InputInv convertRpc(InputInvRpcParam inputInvRpcParam);
}
