package com.elitesland.fin.application.convert.recorder;
import com.elitesland.fin.application.facade.param.recorder.RecOrderSaveParam;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderVO;
import com.elitesland.fin.domain.entity.recorder.RecOrder;
import com.elitesland.fin.domain.entity.recorder.RecOrderDO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.param.recorder.RecOrderRpcParam;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/13 11:39
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface RecOrderConvert {
    RecOrderConvert INSTANCE = Mappers.getMapper(RecOrderConvert.class);

    PagingVO<RecOrderVO> convertPage(PagingVO<RecOrderDTO> param);

    @Mapping(source = "dtlDTOS", target = "dtlVOList")
    RecOrderVO dtoToVo(RecOrderDTO recOrderDTO);

    RecOrderDO convertToDo(RecOrder recOrder);

    @Mapping(source = "orderDtlSaveParamList", target = "dtlList")
    RecOrder convertParam(RecOrderSaveParam param);

    List<RecOrderVO> convertList(List<RecOrderDTO> recOrderDTOS);

    @Mapping(source = "recOrderDtlRpcParamList", target = "dtlList")
    RecOrder convertRpc(RecOrderRpcParam recOrderRpcParam);
}
