package com.elitesland.fin.application.facade.param.account;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;

/**
 * 账户表;
 * @author : http://www.chiner.pro
 * @date : 2023-2-16
 */
@Data
@ApiModel(description = "账户表")
public class AccountParam extends BaseModelParam {
    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司id")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("账户编码")
    private String accCode;

    @ApiModelProperty("账户名称")
    private String accName;

    @ApiModelProperty("账户类型")
    private String accType;

    @ApiModelProperty("账户金额")
    private BigDecimal accAmt;

    @ApiModelProperty("账户占用金额")
    private BigDecimal accOccAmt;

    @ApiModelProperty("账户可用金额")
    private BigDecimal accAvaAmt;

    @ApiModelProperty("状态")
    private String state;

}