package com.elitesland.fin.application.service.account;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.application.convert.account.AccountConvert;
import com.elitesland.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.account.AccountDO;
import com.elitesland.fin.repo.account.AccountRepo;
import com.elitesland.fin.repo.account.AccountRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.service.account
 * @date 2023/2/16 09:02
 */
@Service
@RequiredArgsConstructor
public class AccountServiceImpl implements AccountService {

    private final AccountRepoProc accountRepoProc;
    private final AccountRepo accountRepo;


    @Override
    @Transactional
    public Long save(AccountParam accountParam) {
        if (null == accountParam.getState()) {
            accountParam.setState(UdcEnum.FIN_ENABLE_STATE_ENABLE.getValueCode());
        }
        AccountDO accountDO = AccountConvert.INSTANCE.p2En(accountParam);
        AccountDO res = accountRepo.save(accountDO);
        return res.getId();
    }

    @Override
    public AccountVO get(Long id) {
        AccountDO accountDO = accountRepo.findById(id).get();
        AccountVO res = AccountConvert.INSTANCE.en2Vo(accountDO);
        return res;
    }

    @Override
    public PagingVO<AccountVO> page(AccountPageParam accountPageParam) {
        PagingVO<AccountVO> res = accountRepoProc.page(accountPageParam);
        return res;
    }

    @Override
    @Transactional
    public Long updateState(AccountParam accountParam) {
        if (null == accountParam.getId()) {
            throw new BusinessException("id不能为空");
        }
        Long res = accountRepoProc.updateState(accountParam);
        return res;
    }
}
