package com.elitesland.fin.application.service.artype;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.fin.application.convert.artype.ArTypeConvert;
import com.elitesland.fin.application.facade.param.artype.ArTypeParam;
import com.elitesland.fin.application.facade.vo.artype.ArTypeVO;
import com.elitesland.fin.domain.param.artype.ArTypePageParam;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeOuDomainService;
import com.elitesland.fin.infr.dto.artype.ArTypeDTO;
import com.elitesland.fin.infr.dto.artype.ArTypeOuDTO;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.service.artype
 * @date 2022/4/11 13:40
 */
@Service
@RequiredArgsConstructor
public class ArTypeServiceImpl implements ArTypeService {

    private final ArTypeDomainService arTypeDomainService;
    private final ArTypeOuDomainService arTypeOuDomainService;

    private final ArOrderDomainService arOrderDomainService;

    @Override
    public ApiResult<Long> save(ArTypeParam arTypeParam) {
        Long res = arTypeDomainService.save(ArTypeConvert.INSTANCE.convert(arTypeParam));
        return ApiResult.ok(res);
    }

    @Override
    public ApiResult<Long> update(ArTypeParam arTypeParam) {
        if (null == arTypeParam.getId()) {
            throw new BusinessException("主键id不能为空");
        }
        Long res = arTypeDomainService.update(ArTypeConvert.INSTANCE.convert(arTypeParam));
        return ApiResult.ok(res);
    }

    @Override
    public ApiResult<ArTypeVO> get(Long id) {
        ArTypeDTO res = arTypeDomainService.get(id);
        return ApiResult.ok(ArTypeConvert.INSTANCE.convert(res));
    }

    @Override
    public ApiResult<PagingVO<ArTypeVO>> page(ArTypePageParam arTypePageParam) {
        PagingVO<ArTypeDTO> res = arTypeDomainService.page(arTypePageParam);
        return ApiResult.ok(ArTypeConvert.INSTANCE.convertPage(res));
    }

    @Override
    public ApiResult<Boolean> updateEnableFlag(List<Long> ids, boolean enable) {
        List<ArTypeDTO> arTypeDTOS = arTypeDomainService.findByIds(ids);
        if (enable) {
            checkEnableRule(arTypeDTOS);
        }
        if (!enable) {
            checkStopRule(arTypeDTOS);
        }
        Boolean res = arTypeDomainService.updateEnableFlag(ids, enable);
        return ApiResult.ok(res);
    }

    @Override
    public ApiResult<Long> updateDef(Long id) {
        Long res = arTypeDomainService.updateDef(id);
        return ApiResult.ok(res);
    }

    @Override
    public ApiResult<Long> del(Long id) {
        // 查询是否已被公司使用
        List<ArTypeOuDTO> arTypeOuDTOS = arTypeOuDomainService.queryByArTypeId(id);
        if (CollUtil.isNotEmpty(arTypeOuDTOS)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "该数据已分配公司!");
        }
        Boolean aBoolean = arOrderDomainService.queryByArTypeId(id);
        if(aBoolean){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "该数据已关联应收单!");
        }

        Long res = arTypeDomainService.del(id);
        return ApiResult.ok(res);
    }

    @Override
    public ApiResult<List<ArTypeVO>> getList() {

        List<ArTypeDTO> res = arTypeDomainService.getList();
        return ApiResult.ok(ArTypeConvert.INSTANCE.convertList(res));
    }

    @Override
    public ApiResult<ArTypeVO> getDef() {
        ArTypeDTO res = arTypeDomainService.getDef();
        if (res == null) {
            return ApiResult.ok(new ArTypeVO());
        }
        return ApiResult.ok(ArTypeConvert.INSTANCE.convert(res));
    }

    /**
     * 停用状态校验
     */
    private void checkStopRule(List<ArTypeDTO> arTypeDTOS) {
        for (ArTypeDTO arTypeDTO : arTypeDTOS) {
            // 停用需是启用状态
            if (!arTypeDTO.getEnableFlag()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "已停用状态不能再停用");
            }
        }
    }

    /**
     * 启用状态校验
     */
    private void checkEnableRule(List<ArTypeDTO> arTypeDTOS) {

        for (ArTypeDTO arTypeDTO : arTypeDTOS) {
            // 启用需是停用状态
            if (arTypeDTO.getEnableFlag()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "已启用状态不能再启动");
            }
            // 启用需校验已分配公司
            List<ArTypeOuDTO> arTypeOuDTOS = arTypeOuDomainService.queryByArTypeId(arTypeDTO.getId());
            if (CollUtil.isEmpty(arTypeOuDTOS)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "类型代码"+arTypeDTO.getArTypeCode()+"启用前需要分配公司");
            }

        }

    }
}
