package com.elitesland.fin.application.service.cgorder;
import com.alibaba.excel.EasyExcelFactory;
import com.cloudt.apm.common.exception.BusinessException;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.service.SysUserService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.cgorder.CgOrderConvert;
import com.elitesland.fin.application.facade.param.cgorder.CgOrderPageParam;
import com.elitesland.fin.application.facade.param.cgorder.CgOrderParam;
import com.elitesland.fin.application.facade.vo.cgorder.CgOrderVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.cgorder.CgOrderDO;
import com.elitesland.fin.repo.cgorder.CgOrderRepo;
import com.elitesland.fin.repo.cgorder.CgOrderRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/2/17 14:35
 */
@Service
@RequiredArgsConstructor
public class CgOrderServiceImpl implements CgOrderService{

    private final CgOrderRepo cgOrderRepo;
    private final CgOrderRepoProc cgOrderRepoProc;

    @Autowired
    private SeqNumProvider sysNumberRuleService;

    @SysCodeProc
    @Override
    public PagingVO<CgOrderVO> page(CgOrderPageParam cgOrderPageParam) {
        return  cgOrderRepoProc.page(cgOrderPageParam);
    }

    @SysCodeProc
    @Override
    public CgOrderVO getOne(Long id) {
        return cgOrderRepoProc.queryById(id);
    }

    @Override
    public void export(CgOrderPageParam cgOrderPageParam, HttpServletResponse response) {
        PagingVO<CgOrderVO> page = cgOrderRepoProc.page(cgOrderPageParam);
        try {
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode("", "UTF-8").replace("+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            EasyExcelFactory.write(response.getOutputStream(), CgOrderVO.class).sheet("").doWrite(page.getRecords());
        } catch (IOException e) {
            throw new BusinessException("导出失败!");
        }
    }

    @Override
    public List<Long> approve(List<Long> ids) {
        List<CgOrderVO> cgOrderVO = cgOrderRepoProc.queryByIds(ids);
        cgOrderVO.forEach(vo->{
            if(!vo.getState().equals(UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode())){
                throw new BusinessException("只有草稿状态单据才可拒绝!");
            }
        });
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if(userDetails==null){
            throw new BusinessException("当前登陆人信息获取为空!");
        }
        cgOrderRepoProc.updateByIds(ids, UdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode(),userDetails.getUser());
        return ids;
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public List<Long> reject(CgOrderParam cgOrderParam) {
        List<CgOrderVO> cgOrderVO = cgOrderRepoProc.queryByIds(cgOrderParam.getIds());
        cgOrderVO.forEach(vo->{
            if(!vo.getState().equals(UdcEnum.COM_APPLY_STATUS_DOING.getValueCode())){
                throw new BusinessException("只有审批中状态单据才可拒绝!");
            }
        });
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if(userDetails==null){
            throw new BusinessException("当前登陆人信息获取为空!");
        }
        cgOrderRepoProc.updateByIds(cgOrderParam.getIds(), UdcEnum.COM_APPR_STATUS_REJECTED.getValueCode(),userDetails.getUser());
        return cgOrderParam.getIds();
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public List<Long> cancel(List<Long> ids) {
        List<CgOrderVO> cgOrderVO = cgOrderRepoProc.queryByIds(ids);
        cgOrderVO.forEach(vo->{
            if(!vo.getState().equals(UdcEnum.COM_APPLY_STATUS_REJECTED.getValueCode())){
                throw new BusinessException("只有审批拒绝状态单据才可作废!");
            }
        });
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if(userDetails==null){
            throw new BusinessException("当前登陆人信息获取为空!");
        }
        cgOrderRepoProc.updateByIds(ids, UdcEnum.COM_APPLY_STATUS_VOID.getValueCode(),userDetails.getUser());
        return ids;
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public Long returnCg(CgOrderParam cgOrderParam) {
        CgOrderVO cgOrderVO = cgOrderRepoProc.queryById(cgOrderParam.getId());
        if(!cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0001.getValueCode())&&
                !cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0002.getValueCode())&&
                !cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0003.getValueCode())&&
                !cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0004.getValueCode())&&
                !cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0005.getValueCode())&&
                !cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0006.getValueCode())&&
                !cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0007.getValueCode())&&
                !cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0008.getValueCode())){
            throw new BusinessException("只能退还保证金类型单据!");
        }
        if(!cgOrderVO.getState().equals(UdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode())){
            throw new BusinessException("只能退还已审批的单据!");
        }
        //处理自身退还逻辑
        if(cgOrderParam.getReturnAmt().compareTo(BigDecimal.ZERO)<=0){
            throw new BusinessException("退款金额必须大于0!");
        }
        if(cgOrderParam.getReturnAmt().compareTo(cgOrderVO.getUnrefundAmt())>0){
            throw new BusinessException("退款金额大于未退款金额!");
        }
        BigDecimal unReturnAmt = cgOrderVO.getUnrefundAmt().subtract(cgOrderParam.getReturnAmt());
        BigDecimal returnAmt = cgOrderVO.getRefundAmt().subtract(cgOrderParam.getReturnAmt());
        //更新本身单据的已退款未退款金额
        cgOrderRepoProc.updateAmtById(cgOrderParam.getId(),unReturnAmt,returnAmt);
        CgOrderDO cgOrderDO = CgOrderConvert.INSTANCE.voToDo(cgOrderVO);
        cgOrderDO.setAuditRejectReason(null);
        cgOrderDO.setAuditTime(null);
        cgOrderDO.setAuditUserId(null);
        cgOrderDO.setAuditUser(null);
        cgOrderDO.setState(UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode());
        cgOrderDO.setType(UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0004.getValueCode());
        String docNo = sysNumberRuleService.generateCode(Application.NAME, "CG_ORDER", new ArrayList<>());
        cgOrderDO.setDocNo(docNo);
        cgOrderDO.setTotalAmt(cgOrderParam.getReturnAmt());
        cgOrderDO.setSourceNo(cgOrderVO.getDocNo());
        cgOrderDO.setSourceId(cgOrderVO.getId());
        return null;
    }
}
