package com.elitesland.fin.application.service.inputinv;

import com.elitesland.fin.application.convert.inputinv.InputInvConvert;
import com.elitesland.fin.application.facade.param.inputInv.InputInvParam;
import com.elitesland.fin.application.facade.param.inputInv.InputInvSaveParam;
import com.elitesland.fin.application.facade.vo.inputinv.InputInvVO;
import com.elitesland.fin.domain.entity.inputinv.InputInv;
import com.elitesland.fin.domain.param.inputinv.InputInvPageParam;
import com.elitesland.fin.domain.service.inputinv.InputInvDomainService;
import com.elitesland.fin.dubbo.workflow.WorkflowRpcService;
import com.elitesland.fin.infr.dto.inputinv.InputInvDTO;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.security.util.SecurityUtil;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/5/6 13:19
 */
@Service
@RequiredArgsConstructor
public class InputInvServiceImpl implements InputInvService {

    private final InputInvDomainService inputInvDomainService;
    private final WorkflowRpcService workflowRpcService;


    @Override
    @SysCodeProc
    public PagingVO<InputInvVO> page(InputInvPageParam pageParam) {
        PagingVO<InputInvDTO> page = inputInvDomainService.page(pageParam);
        return InputInvConvert.INSTANCE.convertPage(page);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public List<Long> deleteByIds(List<Long> ids) {
        return inputInvDomainService.deleteByIds(ids);
    }

    @SysCodeProc
    @Override
    public InputInvVO queryById(Long id) {
        InputInvDTO inputInvDTO = inputInvDomainService.queryById(id, false);
        return InputInvConvert.INSTANCE.dtoToVo(inputInvDTO);
    }

    @SysCodeProc
    @Override
    public InputInvVO queryDetailsById(Long id) {
        InputInvDTO inputInvDTO = inputInvDomainService.queryById(id, true);
        return InputInvConvert.INSTANCE.dtoToVo(inputInvDTO);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public ApiResult<Long> save(InputInvSaveParam param) {
        InputInv inputInv = InputInvConvert.INSTANCE.convertParam(param);
        return ApiResult.ok(inputInvDomainService.save(inputInv));
    }

    @Override
    @Transactional(propagation= Propagation.REQUIRES_NEW,rollbackFor = {Exception.class})
    public ApiResult<Long> submit(InputInvSaveParam param) {
        InputInv inputInv = InputInvConvert.INSTANCE.convertParam(param);
        Long resId = inputInvDomainService.submit(inputInv);
        // 启动工作流
        if (inputInv.getProcInstId() == null
                || WorkflowConstant.CAN_START_PROC_STATUSES.contains(inputInv.getProcInstStatus())) {
            // 启动流程
            String procInstName = "进项发票审核-" + inputInv.getInvRegNo();
            String procKey = WorkFlowDefKey.FIN_INPUT_INV.name();
            ProcessInfo processInfo = workflowRpcService.startProcess(procKey, procInstName, resId.toString(), new HashMap<>());
            inputInvDomainService.updateWorkInfo(processInfo, resId);
        }
        return ApiResult.ok(resId);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void approved(Long id) {
        SysUserDTO user = SecurityUtil.getUser().getUser();
        if (user == null) {
            throw new BusinessException("当前登陆人信息为空!");
        }
        inputInvDomainService.approved(id, user);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void reject(InputInvParam param) {
        SysUserDTO user = SecurityUtil.getUser().getUser();
        if (user == null) {
            throw new BusinessException("当前登陆人信息为空!");
        }
        inputInvDomainService.reject(param, user);
    }
}
