package com.elitesland.fin.application.web.account;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.common.UdcEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.web.account
 * @date 2023/2/15 18:23
 */
@RestController
@RequestMapping("/fin/account")
@RequiredArgsConstructor
@Api(value = "账户", tags = {"账户"})
public class AccountController {

    private final AccountService accountService;

    @PostMapping("save")
    @ApiOperation("新增/修改账户信息")
    public ApiResult<Long> page(@RequestBody AccountParam accountParam) {
        Long res = accountService.save(accountParam);
        return ApiResult.ok(res);
    }

    @PostMapping("enable")
    @ApiOperation("新增/修改账户信息")
    public ApiResult<Long> enable(@RequestBody AccountParam accountParam) {
        accountParam.setState(UdcEnum.FIN_ENABLE_STATE_ENABLE.getValueCode());
        Long res = accountService.updateState(accountParam);
        return ApiResult.ok(res);
    }

    @PostMapping("disEnable")
    @ApiOperation("新增/修改账户信息")
    public ApiResult<Long> disEnable(@RequestBody AccountParam accountParam) {
        accountParam.setState(UdcEnum.FIN_ENABLE_STATE_DISENABLE.getValueCode());
        Long res = accountService.updateState(accountParam);
        return ApiResult.ok(res);
    }

    @GetMapping("get")
    @ApiOperation("账户列表详情")
    public ApiResult<AccountVO> get(Long id) {
        AccountVO res = accountService.get(id);
        return ApiResult.ok(res);
    }

    @PostMapping("page")
    @ApiOperation("账户列表查询")
    public ApiResult<PagingVO<AccountVO>> page(@RequestBody AccountPageParam accountPageParam) {
        PagingVO<AccountVO> res = accountService.page(accountPageParam);
        return ApiResult.ok(res);
    }
}
