package com.elitesland.fin.application.web.cgorder;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.cgorder.CgOrderPageParam;
import com.elitesland.fin.application.facade.param.cgorder.CgOrderParam;
import com.elitesland.fin.application.facade.vo.cgorder.CgOrderVO;
import com.elitesland.fin.application.service.cgorder.CgOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/2/17 14:05
 */
@RestController
@RequestMapping("/fin/charge")
@RequiredArgsConstructor
@Api(value = "充值单", tags = {"充值单"})
public class CgOrderController {

    private final CgOrderService cgOrderService;

    @PostMapping("/save")
    @ApiOperation("新增/修改充值单")
    public ApiResult<Long> save(@RequestBody CgOrderParam cgOrderParam) {
        return ApiResult.ok();
    }

    @PostMapping("/submit")
    @ApiOperation("提交充值单")
    public ApiResult<Long> submit(@RequestBody CgOrderParam cgOrderParam) {
        return ApiResult.ok();
    }

    @PostMapping("/page")
    @ApiOperation("分页查询充值单")
    public ApiResult<PagingVO<CgOrderVO>> page(@RequestBody CgOrderPageParam cgOrderPageParam) {
        try {
            return ApiResult.ok(cgOrderService.page(cgOrderPageParam));
        } catch (Exception e) {
         return   ApiResult.fail(e.getMessage());
        }
    }

    @GetMapping("/getOne/{id}")
    @ApiOperation("账户列表详情")
    public ApiResult<CgOrderVO> getOne(@PathVariable("id") Long id) {
        try {
            return ApiResult.ok(cgOrderService.getOne(id));
        } catch (Exception e) {
            return   ApiResult.fail(e.getMessage());
        }
    }

    @PostMapping("/approve")
    @ApiOperation("批量审批充值单")
    public ApiResult<List<Long>> approve(@RequestBody List<Long> ids) {
        try {
            return ApiResult.ok(cgOrderService.approve(ids));
        } catch (Exception e) {
            return   ApiResult.fail(e.getMessage());
        }
    }

    @PostMapping("/reject")
    @ApiOperation("审批拒绝充值单")
    public ApiResult<List<Long>> reject(@RequestBody CgOrderParam cgOrderParam) {
        try {
            return ApiResult.ok( cgOrderService.reject(cgOrderParam));
        } catch (Exception e) {
            return   ApiResult.fail(e.getMessage());
        }
    }

    @PostMapping("/cancel")
    @ApiOperation("作废充值单")
    public ApiResult<List<Long>> cancel(List<Long> ids) {
        try {
            return ApiResult.ok(cgOrderService.cancel(ids));
        } catch (Exception e) {
            return   ApiResult.fail(e.getMessage());
        }
    }

    @PostMapping("/return")
    @ApiOperation("退还充值单")
    public ApiResult<Long> returnCg(@RequestBody CgOrderParam cgOrderParam) {
        return ApiResult.ok();
    }

    @PostMapping("/export")
    @ApiOperation("分页查询导出数据,导出条数为分页参数设置,可设置默认5000条")
    public void export(@RequestBody CgOrderPageParam cgOrderPageParam, HttpServletResponse response) {
        try {
            cgOrderService.export(cgOrderPageParam,response);
        } catch (Exception e) {
            ApiResult.fail(e.getMessage());
        }
    }
}
