package com.elitesland.fin.application.web.saleinv;

import com.elitesland.fin.application.facade.param.saleinv.SaleInvParam;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDtlVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvdDtlVO;
import com.elitesland.fin.application.service.saleinv.SaleInvService;
import com.elitesland.fin.domain.param.saleinv.SaleInvDtlPageParam;
import com.elitesland.fin.domain.param.saleinv.SaleInvPageParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.web.saleinv
 * @date 2022/5/6 14:32
 */
@RestController
@RequestMapping("/fin/saleInv")
@RequiredArgsConstructor
@Api(tags = {"销售发票列表"})
public class SaleInvController {

    public final SaleInvService saleInvService;

    @PostMapping("page")
    @ApiOperation("分页查询销售发票列表")
    public ApiResult<PagingVO<SaleInvVO>> page(@RequestBody SaleInvPageParam param) {
        PagingVO<SaleInvVO> res = saleInvService.page(param);
        return ApiResult.ok(res);
    }

    @ApiOperation("获取销售发票详情接口")
    @GetMapping("get")
    public ApiResult<SaleInvVO> get(Long id) {
        SaleInvVO res = saleInvService.get(id);
        return ApiResult.ok(res);
    }

    @PostMapping("updateInvInfo")
    @ApiOperation("【列表编辑】更信息表编号，快递单号，备注")
    public ApiResult<Long> updateInvInfo(@RequestBody SaleInvParam saleInvParam) {
        Long res = saleInvService.updateInvInfo(saleInvParam);
        return ApiResult.ok(res);
    }

    @GetMapping("dtl/getList")
    @ApiOperation("查询销售明细列表")
    public ApiResult<List<SaleInvDtlVO>> getList(Long masId) {
        List<SaleInvDtlVO> res = saleInvService.getList(masId);
        return ApiResult.ok(res);
    }

    @PostMapping("dtlPage")
    @ApiOperation("查询销售发票明细分页")
    public ApiResult<PagingVO<SaleInvDtlVO>> dtlPage(@RequestBody SaleInvDtlPageParam saleInvDtlPageParam) {
        PagingVO<SaleInvDtlVO> res = saleInvService.dtlPage(saleInvDtlPageParam);
        return ApiResult.ok(res);
    }

    @GetMapping("dtl/getInvdLists")
    @ApiOperation("查询已开票明细列表")
    public ApiResult<List<SaleInvdDtlVO>> getInvdLists(Long masId) {
        List<SaleInvdDtlVO> res = saleInvService.getInvdLists(masId);
        return ApiResult.ok(res);
    }

    @PostMapping("save")
    @ApiOperation("新增销售发票")
    public ApiResult<Long> save(@RequestBody SaleInvParam saleInvParam) {
        Long res = saleInvService.save(saleInvParam);
        return ApiResult.ok(res);
    }


    @PostMapping("update")
    @ApiOperation("修改销售发票")
    public ApiResult<Long> update(@RequestBody SaleInvParam saleInvParam) {
        Long res = saleInvService.update(saleInvParam);
        return ApiResult.ok(res);
    }

    @PostMapping("submit")
    @ApiOperation("销售发票提交")
    public ApiResult<Long> submit(@RequestBody SaleInvParam saleInvParam) {
        Long res = saleInvService.submit(saleInvParam);
        return ApiResult.ok(res);
    }

    @DeleteMapping("del")
    @ApiOperation("删除销售发票数据")
    public ApiResult<Long> del(@RequestBody List<Long> ids) {
        Long res = saleInvService.del(ids);
        return ApiResult.ok(res);
    }

}
