package com.elitesland.fin.domain.entity.aporder;

import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-3-16
 * @desc : 应付单明细汇总
 */
@Entity
@Table(name="ap_order_dtl_group")
@org.hibernate.annotations.Table(appliesTo = "ap_order_dtl_group", comment = "应付单明细汇总")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class ApOrderDtlGroupDO extends BaseModel implements Serializable {


    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '总单ID'")
    private Long masId;

    @Column(name = "item_id", columnDefinition = "bigint(20) comment '商品ID'")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(20) comment '商品编码'")
    private String itemCode;

    @Column(name = "item_name", columnDefinition = "varchar(200) comment '商品名称'")
    private String itemName;

    @Column(name = "small_cate_code", columnDefinition = "varchar(200) comment '小类编码'")
    private String smallCateCode;

    @Column(name = "small_cate_name", columnDefinition = "varchar(200) comment '小类名称'")
    private String smallCateName;

    @Column(name = "qty", columnDefinition = "decimal(16,4) comment '数量'")
    private BigDecimal qty;

    @Column(name = "total_amt", columnDefinition = "decimal(18,8) comment '含税总金额'")
    private BigDecimal totalAmt;

    @Column(name = "excl_tax_amt", columnDefinition = "decimal(18,8) comment '不含税总金额'")
    private BigDecimal exclTaxAmt;

    @Column(name = "tax_amt", columnDefinition = "decimal(18,8) comment '税额'")
    private BigDecimal taxAmt;

    @Column(name = "total_cur_amt", columnDefinition = "decimal(18,8) comment '含税总金额(本位币)'")
    private BigDecimal totalCurAmt;

    @Column(name = "excl_tax_cur_amt", columnDefinition = "decimal(18,8) comment '不含税总金额(本位币)'")
    private BigDecimal exclTaxCurAmt;

    @Column(name = "tax_cur_amt", columnDefinition = "decimal(18,8) comment '税额(本位币)'")
    private BigDecimal taxCurAmt;

    @Column(name = "bu_id", columnDefinition = "bigint(20) comment '费用部门ID'")
    private Long buId;

    @Column(name = "bu_name", columnDefinition = "varchar(200) comment '费用部门'")
    private String buName;

    @Column(name = "expenses_type", columnDefinition = "varchar(20) comment '费用类型'")
    private String expensesType;







    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApOrderDtlGroupDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApOrderDtlGroupDO entity = (ApOrderDtlGroupDO) o;
        return getId().equals(entity.getId());
    }
    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}