package com.elitesland.fin.domain.entity.apverrec;

import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-4-20
 * @desc : 应付核销记录
 */
@Entity
@Table(name="ap_ver_rec")
@org.hibernate.annotations.Table(appliesTo = "ap_ver_rec", comment = "应付核销记录")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class ApVerRecDO extends BaseModel implements Serializable {


    private static final long serialVersionUID = -6093188885641152403L;

    @Column(name = "ver_no", columnDefinition = "varchar(20) comment '核销编号'")
    private String verNo;

    @Column(name = "ap_ver_amt", columnDefinition = "decimal(18,8) comment '应付核销金额'")
    private BigDecimal apVerAmt;

    @Column(name = "pay_ver_amt", columnDefinition = "decimal(18,8) comment '付款核销金额'")
    private BigDecimal payVerAmt;

    @Column(name = "cancel_user", columnDefinition = "varchar(20) comment '取消人'")
    private String cancelUser;

    @Column(name = "cancel_user_id", columnDefinition = "bigint(20) comment '取消人ID'")
    private Long cancelUserId;

    @Column(name = "cancel_date", columnDefinition = "datetime(6) comment '取消时间'")
    private LocalDateTime cancelDate;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApVerRecDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApVerRecDO entity = (ApVerRecDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

}