package com.elitesland.fin.domain.entity.artype;

import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-4-11
 * @desc : 应收单类型定义
 */
@Entity
@Table(name="ar_type")
@org.hibernate.annotations.Table(appliesTo = "ar_type", comment = "应收单类型定义")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class ArTypeDO extends BaseModel implements Serializable {


    @Column(name = "ar_type_code", columnDefinition = "varchar(40) comment '应付单类型代码'")
    private String arTypeCode;

    @Column(name = "ar_type_name", columnDefinition = "varchar(40) comment '应付单类型名称'")
    private String arTypeName;

    @Column(name = "enable_flag", columnDefinition = "tinyint(1) comment '启用标志'")
    private Boolean enableFlag;

    @Column(name = "auto_audit", columnDefinition = "tinyint(1) comment '自动审核'")
    private Boolean autoAudit;

    @Column(name = "default_flag", columnDefinition = "tinyint(1) comment '默认'")
    private Boolean defaultFlag;




    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArTypeDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArTypeDO entity = (ArTypeDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

}