package com.elitesland.fin.domain.entity.artype;

import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-4-11
 * @desc : 应收单类型定义对应公司
 */
@Entity
@Table(name="ar_type_ou")
@org.hibernate.annotations.Table(appliesTo = "ar_type_ou", comment = "应收单类型定义对应公司")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class ArTypeOuDO extends BaseModel implements Serializable {


    @Column(name = "ar_type_id", columnDefinition = "bigint(20) comment '应收单类型定义ID'")
    private Long arTypeId;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司ID'")
    private Long ouId;

    @Column(name = "ou_name", columnDefinition = "varchar(50) comment '公司名称'")
    private String ouName;

    @Column(name = "ou_code", columnDefinition = "varchar(20) comment '公司编号'")
    private String ouCode;

    @Column(name = "ou_type", columnDefinition = "varchar(20) comment '公司类型'")
    private String ouType;





    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArTypeOuDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArTypeOuDO entity = (ArTypeOuDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

}