package com.elitesland.fin.domain.entity.arverrec;

import com.elitesland.fin.domain.entity.apverrec.ApVerRecDtlDO;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author zhiyu.he
 * @date 2022/4/26 13:13
 */
@Entity
@Table(name="ar_ver_rec_dtl")
@org.hibernate.annotations.Table(appliesTo = "ar_ver_rec_dtl", comment = "应收核销记录明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class ArVerRecDtlDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -7196705552095790631L;

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '总单ID'")
    private Long masId;

    @Column(name = "ver_no", columnDefinition = "varchar(20) comment '核销编号'")
    private String verNo;

    @Column(name = "ver_date", columnDefinition = "datetime(6) comment '核销日期'")
    private LocalDateTime verDate;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司ID'")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(40) comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(200) comment '公司名称'")
    private String ouName;

    @Column(name = "order_name", columnDefinition = "varchar(40) comment '单据名称'")
    private String orderName;

    @Column(name = "order_no", columnDefinition = "varchar(20) comment '单据编号'")
    private String orderNo;

    @Column(name = "order_type", columnDefinition = "varchar(20) comment '单据类型'")
    private String orderType;

    @Column(name = "order_id", columnDefinition = "bigint(20) comment '单据ID'")
    private Long orderId;

    @Column(name = "cust_id", columnDefinition = "bigint(20) comment '客户ID'")
    private Long custId;

    @Column(name = "cust_code", columnDefinition = "varchar(40) comment '客户名称'")
    private String custCode;

    @Column(name = "cust_name", columnDefinition = "varchar(200) comment '客户商名称'")
    private String custName;

    @Column(name = "bu_date", columnDefinition = "datetime(6) comment '业务日期'")
    private LocalDateTime buDate;

    @Column(name = "curr_code", columnDefinition = "varchar(20) comment '币种编码'")
    private String currCode;

    @Column(name = "curr_name", columnDefinition = "varchar(20) comment '币种'")
    private String currName;

    @Column(name = "amt", columnDefinition = "decimal(18,8) comment '本次核销金额'")
    private BigDecimal amt;

    @Column(name = "verify_type", columnDefinition = "varchar(20) comment '核销方式'")
    private String verifyType;

    @Column(name = "scheme_no", columnDefinition = "varchar(20) comment '核销方案编号'")
    private String schemeNo;

    @Column(name = "scheme_name", columnDefinition = "varchar(50) comment '核销方案名称'")
    private String schemeName;

    @Column(name = "scheme_id", columnDefinition = "bigint(20) comment '核销方案ID'")
    private Long schemeId;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApVerRecDtlDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApVerRecDtlDO entity = (ApVerRecDtlDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
