package com.elitesland.fin.domain.entity.payorder;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.base.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author zhiyu.he
 * @date 2022/3/16 9:01
 */
@Entity
@Table(name = "pay_order")
@org.hibernate.annotations.Table(appliesTo = "pay_order", comment = "付款单")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class PayOrderDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 4517983643339148465L;
    @Column(name = "source_no", columnDefinition = "varchar(20) comment '来源系统单号'")
    private String sourceNo;

    @Column(name = "supp_id", columnDefinition = "bigint(20) comment '供应商ID'")
    private Long suppId;

    @Column(name = "supp_code", columnDefinition = "varchar(40) comment '供应商编码'")
    private String suppCode;

    @Column(name = "supp_name", columnDefinition = "varchar(200) comment '供应商名称'")
    private String suppName;

    @Column(name = "ou_code", columnDefinition = "varchar(40) comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司ID'")
    private Long ouId;

    @Column(name = "ou_name", columnDefinition = "varchar(200) comment '公司名称'")
    private String ouName;

    @Column(name = "ap_type_id", columnDefinition = "bigint(20) comment '应付单类型定义ID'")
    private Long apTypeId;

    @Column(name = "create_mode", columnDefinition = "varchar(20) comment '单据来源'")
    private String createMode;

    @Column(name = "ap_type_name", columnDefinition = "varchar(40) comment '应付单类型名称'")
    private String apTypeName;

    @Column(name = "ap_type_code", columnDefinition = "varchar(40) comment '应付单类型代码'")
    private String apTypeCode;

    @Column(name = "pay_type_id", columnDefinition = "bigint(20) comment '付款单类型ID'")
    private Long payTypeId;

    @Column(name = "pay_type_code", columnDefinition = "varchar(40) comment '付款单类型代码'")
    private String payTypeCode;

    @Column(name = "pay_type_name", columnDefinition = "varchar(40) comment '付款单类型名称'")
    private String payTypeName;

    @Column(name = "pay_order_no", columnDefinition = "varchar(20) comment '付款单号'")
    private String payOrderNo;

    @Column(name = "curr_code", columnDefinition = "varchar(20) comment '币种编码'")
    private String currCode;

    @Column(name = "curr_name", columnDefinition = "varchar(20) comment '币种'")
    private String currName;

    @Column(name = "operator", columnDefinition = "varchar(20) comment '经办人'")
    private String operator;

    @Column(name = "oper_user_id", columnDefinition = "bigint(20) comment '经办人ID'")
    private Long operUserId;

    @Column(name = "bu_type", columnDefinition = "varchar(20) comment '业务类型'")
    private String buType;

    @Column(name = "total_amt", columnDefinition = "decimal(18,8) comment '含税总金额'")
    private BigDecimal totalAmt;

    @Column(name = "total_cur_amt", columnDefinition = "decimal(18,8) comment '含税总金额(本位币)'")
    private BigDecimal totalCurAmt;

    @Column(name = "bu_date", columnDefinition = "datetime(6) comment '业务日期'")
    private LocalDateTime buDate;

    @Column(name = "audit_user_id", columnDefinition = "bigint(20) comment '审核人ID'")
    private Long auditUserId;

    @Column(name = "audit_user", columnDefinition = "varchar(20) comment '审核人'")
    private String auditUser;

    @Column(name = "audit_date", columnDefinition = "datetime(6) comment '审核时间'")
    private LocalDateTime auditDate;

    @Column(name = "audit_rejection", columnDefinition = "varchar(200) comment '审核拒绝理由'")
    private String auditRejection;

    @Column(name = "order_state", columnDefinition = "varchar(20) comment '单据状态'")
    private String orderState;

    @Column(name = "exchange_rate", columnDefinition = "decimal(18,8) comment '汇率'")
    private BigDecimal exchangeRate;

    @Column(name = "init_flag", columnDefinition = "tinyint(1) comment '是否期初'")
    private Boolean initFlag;

    @Column(name = "real_pay_amt", columnDefinition = "decimal(18,8) comment '实际支付金额'")
    private BigDecimal realPayAmt;

    @Column(name = "real_pay_cur_amt", columnDefinition = "decimal(18,8) comment '实际支付金额(本位币)'")
    private BigDecimal realPayCurAmt;

    @Column(name = "ap_date", columnDefinition = "datetime(6) comment '预计付款日期'")
    private LocalDateTime apDate;

    @Column(name = "ap_flag", columnDefinition = "tinyint(1) comment '是否预付'")
    private Boolean apFlag;

    @Column(name = "local_curr_code", columnDefinition = "varchar(20) comment '本位币名称'")
    private String localCurrCode;

    @Column(name = "local_curr_name", columnDefinition = "varchar(20) comment '本位币编码'")
    private String localCurrName;

    @Column(name = "ver_state", columnDefinition = "varchar(20) comment '核销状态'")
    private String verState;

    @Column(name = "ver_amt", columnDefinition = "decimal(18,8) comment '已核销金额'")
    private BigDecimal verAmt;

    @Column(name = "proc_inst_id", columnDefinition = "varchar(40) comment '流程实例ID'")
    private String procInstId;

    @Column(name = "proc_inst_status", columnDefinition = "varchar(20) comment '流程实例状态'")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @Column(name = "submit_time", columnDefinition = "datetime(6) comment '提交时间'")
    private LocalDateTime submitTime;

    @Column(name = "approved_time", columnDefinition = "datetime(6) comment '审批通过时间'")
    private LocalDateTime approvedTime;

    @Column(name = "addr_no", columnDefinition = "varchar(50) comment '地址号'")
    private String addrNo;

    @Column(name = "supp_addr_no", columnDefinition = "varchar(50) comment '供应商地址号'")
    private String suppAddrNo;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PayOrderDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PayOrderDO entity = (PayOrderDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
