package com.elitesland.fin.domain.entity.rectype;

import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author zhiyu.he
 * @date 2022/4/11 13:12
 */
@Entity
@Table(name="rec_type_ou")
@org.hibernate.annotations.Table(appliesTo = "rec_type_ou", comment = "收款单类型定义分配公司")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class RecTypeOuDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 8660447862558101385L;

    @Column(name = "rec_type_id", columnDefinition = "bigint(20) comment '收款单类型定义ID'")
    private Long recTypeId;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司ID'")
    private Long ouId;

    @Column(name = "ou_name", columnDefinition = "varchar(50) comment '公司名称'")
    private String ouName;

    @Column(name = "ou_code", columnDefinition = "varchar(20) comment '公司编号'")
    private String ouCode;

    @Column(name = "ou_type", columnDefinition = "varchar(20) comment '公司类型'")
    private String ouType;
}
