package com.elitesland.fin.domain.entity.saleinv;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-5-6
 * @desc : 销售发票
 */
@Entity
@Table(name="sale_inv")
@org.hibernate.annotations.Table(appliesTo = "sale_inv", comment = "销售发票")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class SaleInvDO extends BaseModel implements Serializable {


    @Column(name = "source_sys_no", columnDefinition = "varchar(20) comment '来源系统单号'")
    private String sourceSysNo;

    @Column(name = "apply_no", columnDefinition = "varchar(100) comment '开票申请单号'")
    private String applyNo;

    @Column(name = "ou_code", columnDefinition = "varchar(40) comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司ID'")
    private Long ouId;

    @Column(name = "ou_name", columnDefinition = "varchar(200) comment '公司名称'")
    private String ouName;

    @Column(name = "tax_rate", columnDefinition = "decimal(18,8) comment '税率'")
    private BigDecimal taxRate;

    @Column(name = "inv_reg_no", columnDefinition = "varchar(20) comment '发票登记单号'")
    private String invRegNo;

    @Column(name = "curr_code", columnDefinition = "varchar(20) comment '币种编码'")
    private String currCode;

    @Column(name = "curr_name", columnDefinition = "varchar(20) comment '币种'")
    private String currName;

    @Column(name = "local_curr_code", columnDefinition = "varchar(20) comment '本位币编码'")
    private String localCurrCode;

    @Column(name = "local_curr_name", columnDefinition = "varchar(20) comment '本位币名称'")
    private String localCurrName;

    @Column(name = "total_amt", columnDefinition = "decimal(18,8) comment '含税总金额(开票申请金额)'")
    private BigDecimal totalAmt;

    @Column(name = "total_cur_amt", columnDefinition = "decimal(18,8) comment '含税总金额(本位币)'")
    private BigDecimal totalCurAmt;

    @Column(name = "sale_inv_title", columnDefinition = "varchar(40) comment '销售方发票抬头'")
    private String saleInvTitle;

    @Column(name = "sale_tax_no", columnDefinition = "varchar(20) comment '销售税号'")
    private String saleTaxNo;

    @Column(name = "sale_tel", columnDefinition = "varchar(20) comment '销售方电话'")
    private String saleTel;

    @Column(name = "sale_add", columnDefinition = "varchar(100) comment '销售详细地址'")
    private String saleAdd;

    @Column(name = "sale_bank", columnDefinition = "varchar(100) comment '销售方开户行'")
    private String saleBank;

    @Column(name = "sale_bank_acc", columnDefinition = "varchar(200) comment '销售方银行账号'")
    private String saleBankAcc;

    @Column(name = "sale_remark", columnDefinition = "varchar(100) comment '销售方备注'")
    private String saleRemark;

    @Column(name = "sale_id", columnDefinition = "bigint(20) comment '供应商ID'")
    private Long saleId;

    @Column(name = "sale_name", columnDefinition = "varchar(200) comment '供应商名称'")
    private String saleName;

    @Column(name = "sale_code", columnDefinition = "varchar(40) comment '供应商编码'")
    private String saleCode;

    @Column(name = "cust_inv_title", columnDefinition = "varchar(100) comment '客户方发票抬头'")
    private String custInvTitle;

    @Column(name = "cust_tax_no", columnDefinition = "varchar(100) comment '纳税人识别号'")
    private String custTaxNo;

    @Column(name = "cust_add", columnDefinition = "varchar(100) comment '客户地址'")
    private String custAdd;

    @Column(name = "cust_tel", columnDefinition = "varchar(20) comment '客户电话'")
    private String custTel;

    @Column(name = "cust_bank", columnDefinition = "varchar(100) comment '客户银行'")
    private String custBank;

    @Column(name = "cust_bank_acc", columnDefinition = "varchar(100) comment '客户银行账号'")
    private String custBankAcc;

    @Column(name = "cust_remark", columnDefinition = "varchar(200) comment '客户备注'")
    private String custRemark;

    @Column(name = "cust_id", columnDefinition = "bigint(20) comment '客户id'")
    private Long custId;

    @Column(name = "cust_name", columnDefinition = "varchar(100) comment '客户名称'")
    private String custName;

    @Column(name = "cust_code", columnDefinition = "varchar(50) comment '客户编码'")
    private String custCode;

    @Column(name = "inv_user", columnDefinition = "varchar(20) comment '开票人'")
    private String invUser;

    @Column(name = "rec_user", columnDefinition = "varchar(20) comment '收款人'")
    private String recUser;

    @Column(name = "rev_user", columnDefinition = "varchar(20) comment '复核人'")
    private String revUser;

    @Column(name = "audit_user_id", columnDefinition = "bigint(20) comment '审核人ID'")
    private Long auditUserId;

    @Column(name = "push_method", columnDefinition = "varchar(100) comment '推送方式'")
    private String pushMethod;

    @Column(name = "phone", columnDefinition = "varchar(20) comment '手机号'")
    private String phone;

    @Column(name = "email", columnDefinition = "varchar(100) comment '邮箱'")
    private String email;

    @Column(name = "info_no", columnDefinition = "varchar(100) comment '信息表编号'")
    private String infoNo;

    @Column(name = "express_no", columnDefinition = "varchar(100) comment '快递编号'")
    private String expressNo;

    @Column(name = "inv_state", columnDefinition = "varchar(20) comment '开票状态'")
    private String invState;

    @Column(name = "audit_user", columnDefinition = "varchar(20) comment '审核人'")
    private String auditUser;

    @Column(name = "audit_date", columnDefinition = "datetime(6) comment '审核时间'")
    private LocalDateTime auditDate;

    @Column(name = "order_state", columnDefinition = "varchar(20) comment '单据状态'")
    private String orderState;

    @Column(name = "exchange_rate", columnDefinition = "decimal(18,8) comment '汇率'")
    private BigDecimal exchangeRate;

    @Column(name = "audit_rejection", columnDefinition = "varchar(200) comment '审核拒绝理由'")
    private String auditRejection;

    @Column(name = "create_mode", columnDefinition = "varchar(20) comment '单据来源'")
    private String createMode;

    @Column(name = "inv_type", columnDefinition = "varchar(20) comment '发票类型'")
    private String invType;

    @Column(name = "proc_inst_id", columnDefinition = "varchar(40) comment '流程实例ID'")
    private String procInstId;

    @Column(name = "proc_inst_status", columnDefinition = "varchar(20) comment '流程实例状态'")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @Column(name = "submit_time", columnDefinition = "datetime(6) comment '提交时间'")
    private LocalDateTime submitTime;

    @Column(name = "approved_time", columnDefinition = "datetime(6) comment '审批通过时间'")
    private LocalDateTime approvedTime;



    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SaleInvDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SaleInvDO entity = (SaleInvDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

}