package com.elitesland.fin.domain.entity.saleinv;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-5-6
 * @desc : 销售发票明细
 */
@Data
public class SaleInvDtl extends BaseModel implements Serializable {


    private Long masId;

    private String taxName;

    private String taxCode;

    private String invNature;

    private String sourceNo;

    private Long sourceId;

    private Integer sourceLine;

    private Long sourceLineId;

    private Long itemId;

    private String itemName;

    private String itemCode;

    private String itemType;

    private String uom;

    private String uomName;

    private BigDecimal qty;

    private BigDecimal price;

    private BigDecimal totalAmt;

    private BigDecimal totalCurAmt;

    private BigDecimal taxRate;

    private BigDecimal taxAmt;

    private BigDecimal taxCurAmt;

    private BigDecimal exclTaxAmt;

    private BigDecimal exclTaxCurAmt;

    private String invType;

    private String invKind;

    private String examType;


    public void check() {
        // 商品
        Assert.notEmpty(this.itemCode, "itemCode is null");
        // 单位
        Assert.notEmpty(this.uom, "uom is null");
        // 数量
        Assert.notNull(this.qty, "qty is null");
        //【含税单价】
        Assert.notNull(this.price, "price is null");
        //【含税金额】*显示，计算逻辑计算，置灰；
        Assert.notNull(this.totalAmt, "totalAmt is null");
        //【税率】*显示，根据商品主数据获取销项税率，可修改；
        Assert.notNull(this.taxRate, "taxRate is null");
        //【税额】*显示，计算逻辑计算，置灰；
        Assert.notNull(this.taxAmt, "taxAmt is null");
    }
}