package com.elitesland.fin.domain.param.inputinv;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhiyu.he
 * @date 2022/5/6 10:34
 */
@Data
public class InputInvPageParam extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -6741208578582550245L;

    @ApiModelProperty("来源系统单号")
    private String sourceNo;

    @ApiModelProperty("发票登记号")
    private String invRegNo;

    @ApiModelProperty("销售公司ID")
    private Long ouId;

    @ApiModelProperty("供应商ID")
    private Long suppId;

    @ApiModelProperty("来源单据")
    private String createMode;

    @ApiModelProperty("单据状态")
    private String orderState;

    @ApiModelProperty("含税金额/开始")
    private BigDecimal totalAmtStart;

    @ApiModelProperty("含税金额/结束")
    private BigDecimal totalAmtEnd;

    @ApiModelProperty("创建日期/开始")
    private LocalDateTime createTimeStart;

    @ApiModelProperty("创建日期/结束")
    private LocalDateTime createTimeEnd;

    @ApiModelProperty("发票类型")
    private String invType;

    @ApiModelProperty("发票号码")
    private String invNo;

    @ApiModelProperty("发票代码")
    private String invCode;
}
