package com.elitesland.fin.domain.service.saleinv;

import com.elitesland.fin.domain.param.saleinv.SaleInvDtlPageParam;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.domain.service.saleinv
 * @date 2022/5/7 13:29
 */
@Service
@RequiredArgsConstructor
public class SaleInvDtlDomainServiceImp implements SaleInvDtlDomainService {

    public final SaleInvDtlRepoProc saleInvDtlRepoProc;


    @Override
    public List<SaleInvDtlDTO> getList(Long masId) {
        List<SaleInvDtlDTO> list = saleInvDtlRepoProc.getList(masId);
        return list;
    }

    @Override
    public PagingVO<SaleInvDtlDTO> dtlPage(SaleInvDtlPageParam saleInvDtlPageParam) {
        PagingVO<SaleInvDtlDTO> res = saleInvDtlRepoProc.dtlPage(saleInvDtlPageParam);
        return res;
    }
}
