package com.elitesland.fin.entity.account;

import com.elitescloud.cloudt.common.base.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 账户表;
 * @author : Karl.wang
 * @date : 2023-2-15
 */
@ApiModel(value = "账户表",description = "账户表")
@Table(name="account")
@Data
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "account", comment = "账户表")
@Entity
@Where(clause = "delete_flag = 0")
public class AccountDO extends BaseModel {
    @Comment("公司编码")
    private String ouCode;

    @Comment("公司id")
    private Long ouId;

    @Comment("公司名称")
    private String ouName;

    @Comment("账户编码")
    private String accCode;

    @Comment("账户名称")
    private String accName;

    @Comment("账户类型")
    private String accType;

    @Comment("账户金额")
    private BigDecimal accAmt;

    @Comment("账户占用金额")
    private BigDecimal accOccAmt;

    @Comment("账户可用金额")
    private BigDecimal accAvaAmt;

    @Comment("状态")
    private String state;


//    @Comment("经销商编码")
//    private String dealerCode;
//
//    @Comment("经销商名称")
//    private String dealerName;
//
//    @Comment("开票方名称")
//    private String invName;
//
//    @Comment("开票方编码")
//    private String invCode;

}