package com.elitesland.fin.infr.dto.recorder;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zhiyu.he
 * @date 2022/4/13 11:00
 */
@Data
public class RecOrderDtlDTO implements Serializable {

    private static final long serialVersionUID = -1910795288494973785L;
    private Long id;

    private Long masId;

    @ApiModelProperty("收款方式")
    @SysCode(sys = "yst-supp", mod = "PAY_METHOD")
    private String recType;
    private String recTypeName;

    @ApiModelProperty("收款类型")
    @SysCode(sys = "yst-sale", mod = "RECEIPT_TYPE")
    private String recKind;
    private String recKindName;

    private String recBank;

    private String recAccount;

    private String recFlow;

    private String sourceNo;

    private Long sourceId;

    private Integer sourceLine;

    private Long sourceLineId;

    private BigDecimal realRecAmt;

    private BigDecimal realRecCurAmt;

    private BigDecimal taxAmt;

    private BigDecimal taxRate;

    private BigDecimal totalAmt;

    private BigDecimal totalCurAmt;

    @ApiModelProperty("费用类型")
    @SysCode(sys = "yst-fin", mod = "EXPENSES_TYPE")
    private String expensesType;
    private String expensesTypeName;

    private BigDecimal taxCurAmt;

    private String remark;
}
