package com.elitesland.fin.infr.dto.saleinv;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Data;

import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-5-6
 * @desc : 销售发票
 */
@Data
public class SaleInvDTO extends BaseViewModel implements Serializable {

    private Long id;

    private String sourceSysNo;

    private String applyNo;

    private String ouCode;

    private Long ouId;

    private String ouName;

    private BigDecimal taxRate;

    private String invRegNo;

    private String currCode;

    private String currName;

    private String localCurrCode;

    private String localCurrName;

    private BigDecimal totalAmt;

    private BigDecimal totalCurAmt;

    private String saleInvTitle;

    private String saleTaxNo;

    private String saleTel;

    private String saleAdd;

    private String saleBank;

    private String saleBankAcc;

    private String saleRemark;

    private Long saleId;

    private String saleName;

    private String saleCode;

    private String custInvTitle;

    private String custTaxNo;

    private String custAdd;

    private String custTel;

    private String custBank;

    private String custBankAcc;

    private String custRemark;

    private Long custId;

    private String custName;

    private String custCode;

    private String invUser;

    private String recUser;

    private String revUser;

    private Long auditUserId;

    private String pushMethod;

    private String phone;

    private String email;

    private String infoNo;

    private String expressNo;

    private String invState;

    private String auditUser;

    private LocalDateTime auditDate;

    private String orderState;

    private BigDecimal exchangeRate;

    private String auditRejection;

    private String createMode;

    private String invType;

    private String procInstId;

    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    private LocalDateTime submitTime;

    private LocalDateTime approvedTime;

}