package com.elitesland.fin.infr.repo.payorder;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.payorder.QPayOrderDO;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.domain.param.payorder.PayOrderParam;
import com.elitesland.fin.infr.dto.common.ApVerDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author zhiyu.he
 * @date 2022/3/16 9:40
 */
@Component
@RequiredArgsConstructor
public class PayOrderRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QPayOrderDO qPayOrderDO = QPayOrderDO.payOrderDO;

    public PayOrderDTO queryById(Long id) {
        return select(PayOrderDTO.class)
                .where(qPayOrderDO.id.eq(id))
                .where(qPayOrderDO.deleteFlag.eq(0))
                .fetchOne();
    }

    public void deleteByIds(List<Long> ids) {
        jpaQueryFactory.delete(qPayOrderDO)
                .where(qPayOrderDO.id.in(ids))
                .execute();
    }

    public List<PayOrderDTO> queryByPayTypeId(List<Long> ids) {
        return select(PayOrderDTO.class)
                .where(qPayOrderDO.payTypeId.in(ids))
                .fetch();
    }

    public Long audit(List<Long> ids, String auditRejection, SysUserDTO user) {
        return jpaQueryFactory.update(qPayOrderDO)
                .set(qPayOrderDO.auditDate, LocalDateTime.now())
                .set(qPayOrderDO.auditRejection, auditRejection)
                .set(qPayOrderDO.auditUser, user.getUsername())
                .set(qPayOrderDO.auditUserId, user.getId())
                .where(qPayOrderDO.id.in(ids))
                .execute();
    }

    public List<PayOrderDTO> queryByParam(PayOrderParam payOrderParam) {
        // 条件拼接
        List<Predicate> predicates = new ArrayList<>();
        if (!StringUtils.isEmpty(payOrderParam.getCurrCode())) {
            predicates.add(qPayOrderDO.currCode.eq(payOrderParam.getCurrCode()));
        }
        if (payOrderParam.getSuppId() != null) {
            predicates.add(qPayOrderDO.suppId.eq(payOrderParam.getSuppId()));
        }
        if (payOrderParam.getOuId() != null) {
            predicates.add(qPayOrderDO.ouId.eq(payOrderParam.getOuId()));
        }
        if (payOrderParam.getBuDateStart() != null && payOrderParam.getBuDateEnd() != null) {
            predicates.add(qPayOrderDO.buDate.between(payOrderParam.getBuDateStart(), payOrderParam.getBuDateEnd()));
        }
        predicates.add(qPayOrderDO.deleteFlag.eq(0));
        predicates.add(qPayOrderDO.orderState.eq(UdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode()));



        return select(PayOrderDTO.class).
                where(ExpressionUtils.allOf(predicates)).fetch();
    }

    public List<PayOrderDTO> queryByIds(List<Long> ids) {
        return select(PayOrderDTO.class)
                .where(qPayOrderDO.id.in(ids))
                .where(qPayOrderDO.deleteFlag.eq(0))
                .fetch();
    }

    public PagingVO<PayOrderDTO> page(PayOrderPageParam param, List<Long> ids) {
        // 条件拼接
        List<Predicate> predicates = new ArrayList<>();
        if (param.getApFlag() != null) {
            predicates.add(qPayOrderDO.apFlag.eq(param.getApFlag()));
        }
        if (!StringUtils.isEmpty(param.getCreateMode())) {
            predicates.add(qPayOrderDO.createMode.eq(param.getCreateMode()));
        }
        if (param.getInitFlag() != null) {
            predicates.add(qPayOrderDO.initFlag.eq(param.getInitFlag()));
        }
        if (param.getPayTypeId() != null) {
            predicates.add(qPayOrderDO.payTypeId.eq(param.getPayTypeId()));
        }
        if (!StringUtils.isEmpty(param.getVerState())) {
            predicates.add(qPayOrderDO.verState.eq(param.getVerState()));
        }
        if (!StringUtils.isEmpty(param.getOrderState())) {
            predicates.add(qPayOrderDO.orderState.eq(param.getOrderState()));
        }
        if (!StringUtils.isEmpty(param.getCurrCode())) {
            predicates.add(qPayOrderDO.currCode.eq(param.getCurrCode()));
        }
        if (!StringUtils.isEmpty(param.getSourceNo())) {
            predicates.add(qPayOrderDO.sourceNo.like("%" + param.getSourceNo() + "%"));
        }
        if (!StringUtils.isEmpty(param.getPayOrderNo())) {
            predicates.add(qPayOrderDO.payOrderNo.like("%" + param.getPayOrderNo() + "%"));
        }
        if (param.getSuppId() != null) {
            predicates.add(qPayOrderDO.suppId.eq(param.getSuppId()));
        }
        if (!StringUtils.isEmpty(param.getOperator())) {
            predicates.add(qPayOrderDO.operator.like("%" + param.getOperator() + "%"));
        }
        if (param.getOuId() != null) {
            predicates.add(qPayOrderDO.ouId.eq(param.getOuId()));
        }
        predicates.add(qPayOrderDO.buDate.between(param.getBuDateStart(), param.getBuDateEnd()));
        if (!CollUtil.isEmpty(ids)) {
            predicates.add(qPayOrderDO.id.in(ids));
        }

        if (param.getTotalAmtFrom() != null) {
            predicates.add(qPayOrderDO.totalAmt.goe(param.getTotalAmtFrom()));
        }
        if (param.getTotalAmtTo() != null) {
            predicates.add(qPayOrderDO.totalAmt.loe(param.getTotalAmtTo()));
        }
        predicates.add(qPayOrderDO.deleteFlag.eq(0));
        JPAQuery<PayOrderDTO> query = select(PayOrderDTO.class).where(ExpressionUtils.allOf(predicates));
        param.setPaging(query);
        param.fillOrders(query, qPayOrderDO);
        return PagingVO.<PayOrderDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qPayOrderDO.id,
                qPayOrderDO.sourceNo,
                qPayOrderDO.suppId,
                qPayOrderDO.suppCode,
                qPayOrderDO.suppName,
                qPayOrderDO.ouCode,
                qPayOrderDO.ouId,
                qPayOrderDO.ouName,
                qPayOrderDO.apTypeId,
                qPayOrderDO.apTypeCode,
                qPayOrderDO.apTypeName,
                qPayOrderDO.payTypeId,
                qPayOrderDO.payTypeCode,
                qPayOrderDO.payTypeName,
                qPayOrderDO.payOrderNo,
                qPayOrderDO.currCode,
                qPayOrderDO.currName,
                qPayOrderDO.operator,
                qPayOrderDO.operUserId,
                qPayOrderDO.buType,
                qPayOrderDO.buDate,
                qPayOrderDO.totalAmt,
                qPayOrderDO.totalCurAmt,
                qPayOrderDO.auditUserId,
                qPayOrderDO.auditDate,
                qPayOrderDO.auditUser,
                qPayOrderDO.orderState,
                qPayOrderDO.exchangeRate,
                qPayOrderDO.initFlag,
                qPayOrderDO.realPayAmt,
                qPayOrderDO.realPayCurAmt,
                qPayOrderDO.apDate,
                qPayOrderDO.apFlag,
                qPayOrderDO.createTime,
                qPayOrderDO.creator,
                qPayOrderDO.modifyTime,
                qPayOrderDO.updater,
                qPayOrderDO.remark,
                qPayOrderDO.auditRejection,
                qPayOrderDO.createMode,
                qPayOrderDO.localCurrCode,
                qPayOrderDO.localCurrName,
                qPayOrderDO.verState,
                qPayOrderDO.verAmt,
                qPayOrderDO.auditDataVersion,
                qPayOrderDO.procInstId,
                qPayOrderDO.procInstStatus,
                qPayOrderDO.approvedTime,
                qPayOrderDO.submitTime,
                qPayOrderDO.addrNo,
                qPayOrderDO.suppAddrNo)
        ).from(qPayOrderDO);
    }

    public ApVerDTO queryVerAmtById(Long id){
        return jpaQueryFactory.select(Projections.bean(ApVerDTO.class,
                qPayOrderDO.id,
                qPayOrderDO.totalAmt,
                qPayOrderDO.verAmt,
                qPayOrderDO.auditDataVersion)).from(qPayOrderDO).where(qPayOrderDO.id.eq(id)).fetchOne();
    }

    public long updateVerAmt(ApVerDTO apVerDTO) {
        return jpaQueryFactory.update(qPayOrderDO).set(qPayOrderDO.verState,apVerDTO.getVerState())
                .set(qPayOrderDO.verAmt, apVerDTO.getVerAmt())
                .set(qPayOrderDO.auditDataVersion,apVerDTO.getAuditDataVersion()+1)
                .where(qPayOrderDO.id.eq(apVerDTO.getId())
                        .and(qPayOrderDO.totalAmt.goe(apVerDTO.getVerAmt()))
                        .and(qPayOrderDO.auditDataVersion.eq(apVerDTO.getAuditDataVersion())))
                .execute();
    }
    public void updateWorkInfo(ProcessInfo processInfo, Long id) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qPayOrderDO)
                .set(qPayOrderDO.procInstStatus, ProcInstStatus.APPROVING)
                .set(qPayOrderDO.procInstId, processInfo.getProcInstId())
                .set(qPayOrderDO.submitTime, LocalDateTime.now())
                .where(qPayOrderDO.id.eq(id));
        if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
            jpaUpdateClause.set(qPayOrderDO.procInstStatus, ProcInstStatus.APPROVING);
        }
        jpaUpdateClause.execute();
    }

}
