package com.elitesland.fin.infr.repo.recorder;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.domain.entity.recorder.QRecOrderDtlDO;
import com.elitesland.fin.domain.param.recorder.RecOrderDtlPageParam;
import com.elitesland.fin.infr.dto.recorder.RecOrderDtlDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/13 10:40
 */
@Component
@RequiredArgsConstructor
public class RecOrderDtlRepoProc {


    private final JPAQueryFactory jpaQueryFactory;

    private final QRecOrderDtlDO qRecOrderDtlDO = QRecOrderDtlDO.recOrderDtlDO;


    public List<Long> queryBySourceNo(String sourceNo) {
        return jpaQueryFactory.select(qRecOrderDtlDO.masId)
                .where(qRecOrderDtlDO.sourceNo.like("%" + sourceNo + "%"))
                .from(qRecOrderDtlDO)
                .fetch();
    }

    public void deleteByMasId(List<Long> masId) {
        jpaQueryFactory.delete(qRecOrderDtlDO)
                .where(qRecOrderDtlDO.masId.in(masId))
                .execute();
    }

    public PagingVO<RecOrderDtlDTO> page(RecOrderDtlPageParam pageParam) {
        // 条件拼接
        List<Predicate> predicates = new ArrayList<>();
        if (pageParam.getMisId() != null) {
            predicates.add(qRecOrderDtlDO.masId.eq(pageParam.getMisId()));
        }
        JPAQuery<RecOrderDtlDTO> query = select(RecOrderDtlDTO.class).where(ExpressionUtils.allOf(predicates));
        pageParam.setPaging(query);
        pageParam.fillOrders(query, qRecOrderDtlDO);
        return PagingVO.<RecOrderDtlDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }
    @SysCodeProc
    public List<RecOrderDtlDTO> queryByMasId(Long masId) {
        return select(RecOrderDtlDTO.class)
                .where(qRecOrderDtlDO.masId.in(masId))
                .fetch();
    }

    public void deleteByMasIds(List<Long> masIds) {
        jpaQueryFactory.delete(qRecOrderDtlDO)
                .where(qRecOrderDtlDO.masId.in(masIds))
                .execute();
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qRecOrderDtlDO.id,
                qRecOrderDtlDO.masId,
                qRecOrderDtlDO.recType,
                qRecOrderDtlDO.recKind,
                qRecOrderDtlDO.recBank,
                qRecOrderDtlDO.recAccount,
                qRecOrderDtlDO.recFlow,
                qRecOrderDtlDO.sourceNo,
                qRecOrderDtlDO.sourceId,
                qRecOrderDtlDO.sourceLine,
                qRecOrderDtlDO.sourceLineId,
                qRecOrderDtlDO.realRecAmt,
                qRecOrderDtlDO.realRecCurAmt,
                qRecOrderDtlDO.taxAmt,
                qRecOrderDtlDO.taxRate,
                qRecOrderDtlDO.totalAmt,
                qRecOrderDtlDO.totalCurAmt,
                qRecOrderDtlDO.expensesType,
                qRecOrderDtlDO.remark,
                qRecOrderDtlDO.taxCurAmt)
        ).from(qRecOrderDtlDO);
    }
}
