package com.elitesland.fin.infr.repo.saleinv;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvParam;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvDO;
import com.elitesland.fin.domain.param.saleinv.SaleInvPageParam;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.infr.repo.saleinv
 * @date 2022/5/6 15:22
 */
@Component
@RequiredArgsConstructor
public class SaleInvRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QSaleInvDO qSaleInvDO = QSaleInvDO.saleInvDO;


    public PagingVO<SaleInvDTO> page(SaleInvPageParam saleInvPageParam, List<Long> ids) {

        List<Predicate> predicates = new ArrayList<>();

        if (null != saleInvPageParam.getOuId()) {
            predicates.add(qSaleInvDO.ouId.eq(saleInvPageParam.getOuId()));
        }
        // 来源单据
        if (!StringUtils.isEmpty(saleInvPageParam.getCreateMode())) {
            predicates.add(qSaleInvDO.createMode.eq(saleInvPageParam.getCreateMode()));
        }
        // 开票申请单号
        if (!StringUtils.isEmpty(saleInvPageParam.getApplyNo())) {
            predicates.add(qSaleInvDO.invRegNo.like("%" + saleInvPageParam.getApplyNo() + "%"));
        }
        // 来源系统单号
        if (!StringUtils.isEmpty(saleInvPageParam.getSourceSysNo())) {
            predicates.add(qSaleInvDO.sourceSysNo.eq(saleInvPageParam.getSourceSysNo()));
        }
        // 客户
        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getCustName())) {
            predicates.add(qSaleInvDO.custName.like("%" + saleInvPageParam.getCustName() + "%"));
        }
        if (null != saleInvPageParam.getCustId()) {
            predicates.add(qSaleInvDO.custId.eq(saleInvPageParam.getCustId()));
        }
        if (null != saleInvPageParam.getCustCode()) {
            predicates.add(qSaleInvDO.custCode.eq(saleInvPageParam.getCustCode()));
        }
        // 发票类型
        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getInvType())) {
            predicates.add(qSaleInvDO.invType.eq(saleInvPageParam.getInvType()));
        }
        // 信息表编号
        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getInfoNo())) {
            predicates.add(qSaleInvDO.infoNo.like("%" + saleInvPageParam.getInfoNo() + "%"));
        }
        // 快递单号
        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getExpressNo())) {
            predicates.add(qSaleInvDO.expressNo.like("%" + saleInvPageParam.getExpressNo() + "%"));
        }
        if (CollUtil.isNotEmpty(ids)) {
            predicates.add(qSaleInvDO.id.in(ids));
        }
        predicates.add(qSaleInvDO.deleteFlag.eq(0));
        JPAQuery<SaleInvDTO> query = select(SaleInvDTO.class)
                .where(ExpressionUtils.allOf(predicates));
        saleInvPageParam.setPaging(query);
        saleInvPageParam.fillOrders(query, qSaleInvDO);
        return PagingVO.<SaleInvDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qSaleInvDO.id,
                qSaleInvDO.createTime,
                qSaleInvDO.updater,
                qSaleInvDO.modifyTime,
                qSaleInvDO.creator,
                qSaleInvDO.remark,
                qSaleInvDO.sourceSysNo,
                qSaleInvDO.applyNo,
                qSaleInvDO.ouCode,
                qSaleInvDO.ouId,
                qSaleInvDO.ouName,
                qSaleInvDO.taxRate,
                qSaleInvDO.invRegNo,
                qSaleInvDO.currCode,
                qSaleInvDO.currName,
                qSaleInvDO.localCurrCode,
                qSaleInvDO.localCurrName,
                qSaleInvDO.totalAmt,
                qSaleInvDO.totalCurAmt,
                qSaleInvDO.saleInvTitle,
                qSaleInvDO.saleTaxNo,
                qSaleInvDO.saleTel,
                qSaleInvDO.saleAdd,
                qSaleInvDO.saleBank,
                qSaleInvDO.saleBankAcc,
                qSaleInvDO.saleRemark,
                qSaleInvDO.saleId,
                qSaleInvDO.saleName,
                qSaleInvDO.saleCode,
                qSaleInvDO.custInvTitle,
                qSaleInvDO.custTaxNo,
                qSaleInvDO.custAdd,
                qSaleInvDO.custTel,
                qSaleInvDO.custBank,
                qSaleInvDO.custBankAcc,
                qSaleInvDO.custRemark,
                qSaleInvDO.custId,
                qSaleInvDO.custName,
                qSaleInvDO.custCode,
                qSaleInvDO.invUser,
                qSaleInvDO.recUser,
                qSaleInvDO.revUser,
                qSaleInvDO.auditUserId,
                qSaleInvDO.pushMethod,
                qSaleInvDO.phone,
                qSaleInvDO.email,
                qSaleInvDO.infoNo,
                qSaleInvDO.expressNo,
                qSaleInvDO.invState,
                qSaleInvDO.auditUser,
                qSaleInvDO.auditDate,
                qSaleInvDO.orderState,
                qSaleInvDO.exchangeRate,
                qSaleInvDO.auditRejection,
                qSaleInvDO.createMode,
                qSaleInvDO.invType,
                qSaleInvDO.procInstId,
                qSaleInvDO.procInstStatus,
                qSaleInvDO.approvedTime,
                qSaleInvDO.submitTime
        )).from(qSaleInvDO);
    }

    public SaleInvDTO get(Long id) {
        SaleInvDTO saleInvDTO = select(SaleInvDTO.class)
                .where(qSaleInvDO.id.eq(id))
                .fetchOne();
        return saleInvDTO;
    }

    public Long del(List<Long> ids) {
        long res = jpaQueryFactory.delete(qSaleInvDO)
                .where(qSaleInvDO.id.in(ids))
                .execute();
        return res;
    }

    public Long updateInvInfo(SaleInvParam saleInvParam) {
        long res = jpaQueryFactory.update(qSaleInvDO)
                .set(qSaleInvDO.remark, saleInvParam.getRemark())
                .set(qSaleInvDO.expressNo, saleInvParam.getExpressNo())
                .set(qSaleInvDO.infoNo, saleInvParam.getInfoNo())
                .where(qSaleInvDO.id.eq(saleInvParam.getId())).execute();
        return res;
    }
    public void updateWorkInfo(ProcessInfo processInfo, Long id) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qSaleInvDO)
                .set(qSaleInvDO.procInstStatus, ProcInstStatus.APPROVING)
                .set(qSaleInvDO.procInstId, processInfo.getProcInstId())
                .set(qSaleInvDO.submitTime, LocalDateTime.now())
                .where(qSaleInvDO.id.eq(id));
        if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
            jpaUpdateClause.set(qSaleInvDO.procInstStatus, ProcInstStatus.APPROVING);
        }
        jpaUpdateClause.execute();
    }
}
