package com.elitesland.fin.infr.repo.saleinv;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvdDtlDO;
import com.elitesland.fin.domain.param.saleinv.SaleInvPageParam;
import com.elitesland.fin.infr.dto.saleinv.SaleInvdDtlDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.infr.repo.saleinv
 * @date 2022/5/6 15:22
 */
@Component
@RequiredArgsConstructor
public class SaleInvdDtlRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QSaleInvdDtlDO qSaleInvdDtlDO = QSaleInvdDtlDO.saleInvdDtlDO;

    public List<Long> getMasId(SaleInvPageParam saleInvPageParam) {

        List<Predicate> predicates = new ArrayList<>();
        // 发票号码
        if (!StringUtils.isEmpty(saleInvPageParam.getInvNo())) {
            predicates.add(qSaleInvdDtlDO.invNo.like("%" + saleInvPageParam.getInvNo() + "%"));
        }
        // 原蓝票号码
        if (!StringUtils.isEmpty(saleInvPageParam.getBlueInvNo())) {
            predicates.add(qSaleInvdDtlDO.blueInvNo.like("%" + saleInvPageParam.getBlueInvNo() + "%"));
        }
        // 开票日期/
        if (null != saleInvPageParam.getInvDateStart() && null != saleInvPageParam.getInvDateEnd()) {
            predicates.add(qSaleInvdDtlDO.invDate.between(saleInvPageParam.getInvDateStart(), saleInvPageParam.getInvDateEnd()));
        }

        // 开票金额/开始
        if (null != saleInvPageParam.getTotalAmtStart()) {
            predicates.add(qSaleInvdDtlDO.totalAmt.goe(saleInvPageParam.getTotalAmtStart()));
        }
        // 开票金额/结束
        if (null != saleInvPageParam.getTotalAmtEnd()) {
            predicates.add(qSaleInvdDtlDO.totalAmt.loe(saleInvPageParam.getTotalAmtEnd()));
        }
        // 红冲状态
        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getRedState())) {
            predicates.add(qSaleInvdDtlDO.redState.eq(saleInvPageParam.getRedState()));
        }
        // 开票状态
        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getInvState())) {
            predicates.add(qSaleInvdDtlDO.invState.eq(saleInvPageParam.getInvState()));
        }
        predicates.add(qSaleInvdDtlDO.deleteFlag.eq(0));
        List<Long> ids = jpaQueryFactory.select(qSaleInvdDtlDO.masId)
                .from(qSaleInvdDtlDO)
                .where(ExpressionUtils.allOf(predicates))
                .fetch();
        return ids;
    }

    public List<SaleInvdDtlDTO> getList(Long masId) {

        List<Predicate> predicates = new ArrayList<>();
        if (null != masId) {
            predicates.add(qSaleInvdDtlDO.masId.eq(masId));
        }
        predicates.add(qSaleInvdDtlDO.deleteFlag.eq(0));
        List<SaleInvdDtlDTO> res = jpaQueryFactory.select(Projections.bean(SaleInvdDtlDTO.class,
                qSaleInvdDtlDO.masId,
                qSaleInvdDtlDO.invNo,
                qSaleInvdDtlDO.flowNo,
                qSaleInvdDtlDO.invCode,
                qSaleInvdDtlDO.checkCode,
                qSaleInvdDtlDO.blueInvCode,
                qSaleInvdDtlDO.blueInvNo,
                qSaleInvdDtlDO.redState,
                qSaleInvdDtlDO.invPdfUrl,
                qSaleInvdDtlDO.invFailCause,
                qSaleInvdDtlDO.invDate,
                qSaleInvdDtlDO.totalAmt,
                qSaleInvdDtlDO.invState

        )).from(qSaleInvdDtlDO)
                .where(ExpressionUtils.allOf(predicates))
                .fetch();
        return res;
    }

    public void delByMasId(List<Long> masIds) {
        if (CollUtil.isEmpty(masIds)) {
            return;
        }
        jpaQueryFactory.delete(qSaleInvdDtlDO)
                .where(qSaleInvdDtlDO.masId.in(masIds))
                .execute();
    }
}
