package com.elitesland.fin.provider.arorder;

import cn.hutool.core.util.StrUtil;
import com.elitesland.fin.Application;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.param.arorder.ArOrderRpcParam;
import com.elitesland.fin.service.aporder.ApOrderRpcService;
import com.elitesland.fin.service.arorder.ArOrderRpcService;
import com.elitescloud.cloudt.common.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.provider.arorder
 * 应收单
 * @date 2022/5/18 15:53
 */
@DubboService
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + ArOrderRpcService.PATH)
public class ArOrderRpcServiceImpl implements ArOrderRpcService {

    public final ArOrderDomainService arOrderDomainService;

    @Override
    public Long save(ArOrderRpcParam arOrderRpcParam) {
        if (CharSequenceUtil.isBlank(arOrderRpcParam.getCreateMode())) {
            throw new BusinessException("createMode不能为空");
        }
        ArOrder arOrder = ArOrderConvert.INSTANCE.convertRpc(arOrderRpcParam);
        Long resId = arOrderDomainService.save(arOrder);
        return resId;
    }
}
