package com.elitesland.fin.provider.inputinv;

import cn.hutool.core.util.StrUtil;
import com.elitesland.fin.Application;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.fin.application.convert.inputinv.InputInvConvert;
import com.elitesland.fin.domain.entity.inputinv.InputInv;
import com.elitesland.fin.domain.service.inputinv.InputInvDomainService;
import com.elitesland.fin.param.inputinv.InputInvRpcParam;
import com.elitesland.fin.service.arorder.ArOrderRpcService;
import com.elitesland.fin.service.inputinv.InputInvRpcService;
import com.elitescloud.cloudt.common.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.provider.inputinv
 * @date 2022/5/20 10:23
 */
@DubboService
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + InputInvRpcService.PATH)
public class InputInvRpcServiceImpl implements InputInvRpcService {

    public final InputInvDomainService inputInvDomainService;

    @Override
    public Long save(InputInvRpcParam inputInvRpcParam) {
        if (CharSequenceUtil.isBlank(inputInvRpcParam.getCreateMode())) {
            throw new BusinessException("来源单据 createMode不能为空");
        }
        InputInv inputInv = InputInvConvert.INSTANCE.convertRpc(inputInvRpcParam);
        Long resId = inputInvDomainService.save(inputInv);
        return resId;
    }
}
