package com.elitesland.fin.provider.workflow;

import com.elitescloud.cloudt.tenant.config.support.TenantSession;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.application.service.workflow.aporder.ApOrderProcessService;
import com.elitesland.fin.application.service.workflow.arorder.ArOrderProcessService;
import com.elitesland.fin.application.service.workflow.inputinv.InputInvProcessService;
import com.elitesland.fin.application.service.workflow.payorder.PayOrderProcessService;
import com.elitesland.fin.application.service.workflow.recorder.RecOrderProcessService;
import com.elitesland.fin.application.service.workflow.saleinv.SaleInvProcessService;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.core.isolate.Isolatable;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Set;

/**
 * @author Jason.zhao
 * @date 2022/5/7 9:41
 */
@Slf4j
@RequiredArgsConstructor
public class FinWorkflowCallBack{

    private final ApOrderProcessService apOrderProcessService;
    private final PayOrderProcessService payOrderProcessService;
    private final ArOrderProcessService arOrderProcessService;
    private final RecOrderProcessService recOrderProcessService;
    private final InputInvProcessService inputInvProcessService;
    private final SaleInvProcessService saleInvProcessService;
    private final Isolatable isolatable;

    public ArrayList<String> taskAssignee(String tenantId, String procDefKey, String taskKey, String businessKey, String customParams) {
        log.info("动态指定任务负责人: 流程定义KEY:{},任务key:{},业务key:{},自定义参数:{},租户ID:{}", procDefKey, taskKey, businessKey, customParams,tenantId);
        try{
            return (ArrayList<String>) isolatable.apply(()->{
                return getUserIds(procDefKey, businessKey, customParams);
            },tenantId);
        }catch (Exception e){
            e.printStackTrace();
        }
        return new ArrayList<>();
    }

    private ArrayList<String> getUserIds(String procDefKey, String businessKey, String customParams) {
        ArrayList<String> userIds = new ArrayList<>();
        if (StringUtils.isNotEmpty(customParams)) {
            if (procDefKey.equals(WorkFlowDefKey.FIN_AP_ORDER.name())) {
                userIds = apOrderProcessService.taskAssignee(businessKey, customParams);
            }
            if (procDefKey.equals(WorkFlowDefKey.FIN_PAY_ORDER.name())) {
                userIds = payOrderProcessService.taskAssignee(businessKey, customParams);
            }
            if (procDefKey.equals(WorkFlowDefKey.FIN_REC_ORDER.name())) {
                userIds = recOrderProcessService.taskAssignee(businessKey, customParams);
            }
            if (procDefKey.equals(WorkFlowDefKey.FIN_SALE_INV.name())) {
                userIds = saleInvProcessService.taskAssignee(businessKey, customParams);
            }
            if (procDefKey.equals(WorkFlowDefKey.FIN_INPUT_INV.name())) {
                userIds = inputInvProcessService.taskAssignee(businessKey, customParams);
            }
            if (procDefKey.equals(WorkFlowDefKey.FIN_AR_ORDER.name())) {
                userIds = apOrderProcessService.taskAssignee(businessKey, customParams);
            }
        }
        SysTenantDTO sysTenantDTO = TenantSession.getCurrentTenant();
        log.info("动态指定任务负责人返回结果:{},租户信息:{}",userIds,sysTenantDTO);
        return userIds;
    }

    public void taskCreated(String tenantId, String procDefKey, String taskKey, String businessKey, Set<String> taskAssignees) {
        log.info("任务创建后回调: 流程定义KEY:{},任务key:{},业务key:{},处理人:{}", procDefKey, taskKey, businessKey, taskAssignees);
    }

    public void taskCompleted(String tenantId, String procDefKey, String taskKey, String businessKey, String taskHandler) {
        log.info("任务完成后回调: 流程定义KEY:{},任务key:{},业务key:{}，任务处理人{}", procDefKey, taskKey, businessKey, taskHandler);
    }

    public void processStatusChange(String tenantId, String procDefKey, ProcInstStatus procInstStatus, String businessKey, CommentInfo commentInfo) {
        log.info("流程回调 procDefKey:" + procDefKey + " ,procInstStatus:" + procInstStatus + ",businessKey:" + businessKey + ",CommentInfo:" + commentInfo);
        if (procDefKey.equals(WorkFlowDefKey.FIN_AP_ORDER.name())) {
            apOrderProcessService.processStatusChange(getId(businessKey), procInstStatus, commentInfo);
        }
        if (procDefKey.equals(WorkFlowDefKey.FIN_AR_ORDER.name())) {
            arOrderProcessService.processStatusChange(getId(businessKey), procInstStatus, commentInfo);
        }
        if (procDefKey.equals(WorkFlowDefKey.FIN_REC_ORDER.name())) {
            recOrderProcessService.processStatusChange(getId(businessKey), procInstStatus, commentInfo);
        }
        if (procDefKey.equals(WorkFlowDefKey.FIN_PAY_ORDER.name())) {
            payOrderProcessService.processStatusChange(getId(businessKey), procInstStatus, commentInfo);
        }
        if (procDefKey.equals(WorkFlowDefKey.FIN_SALE_INV.name())) {
            saleInvProcessService.processStatusChange(getId(businessKey), procInstStatus, commentInfo);
        }
        if (procDefKey.equals(WorkFlowDefKey.FIN_INPUT_INV.name())) {
            inputInvProcessService.processStatusChange(getId(businessKey), procInstStatus, commentInfo);
        }


    }

    private Long getId(String businessKey) {
        return Long.valueOf(businessKey);
    }
}
