package com.elitesland.fin.repo.account;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.entity.account.QAccountDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.repo
 * @date 2023/2/16 15:00
 */
@Component
@RequiredArgsConstructor
public class AccountRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QAccountDO qAccountDO = QAccountDO.accountDO;


    public PagingVO<AccountVO> page(AccountPageParam accountPageParam) {

        List<Predicate> predicates = new ArrayList<>();
        if (StringUtils.isNotBlank(accountPageParam.getAccType())) {
            predicates.add(qAccountDO.accType.eq(accountPageParam.getAccType()));
        }
        if (StringUtils.isNotBlank(accountPageParam.getAccName())) {
            predicates.add(qAccountDO.accName.like('%' + accountPageParam.getAccName() + '%'));
        }
        if (StringUtils.isNotBlank(accountPageParam.getState())) {
            predicates.add(qAccountDO.state.eq(accountPageParam.getState()));
        }

        JPAQuery<AccountVO> query = select(AccountVO.class).where(ExpressionUtils.allOf(predicates));
        accountPageParam.setPaging(query);
        accountPageParam.fillOrders(query, qAccountDO);

        return PagingVO.<AccountVO>builder()
                .total(query.fetch().size())
                .records(query.fetch())
                .build();
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qAccountDO.id,
                qAccountDO.accName,
                qAccountDO.accCode,
                qAccountDO.accType,
                qAccountDO.state,
                qAccountDO.createTime,
                qAccountDO.creator
                )
        ).from(qAccountDO);
    }

    public Long updateState(AccountParam accountParam) {
        long res = jpaQueryFactory.update(qAccountDO)
                .set(qAccountDO.state, accountParam.getState())
                .where(qAccountDO.id.eq(accountParam.getId()))
                .execute();
        return res;
    }
}
