package com.elitesland.fin.repo.cgorder;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.facade.param.cgorder.CgOrderPageParam;
import com.elitesland.fin.application.facade.vo.cgorder.CgOrderVO;
import com.elitesland.fin.entity.cgorder.QCgOrderDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/2/17 14:30
 */
@Component
@RequiredArgsConstructor
public class CgOrderRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QCgOrderDO qCgOrderDO = QCgOrderDO.cgOrderDO;

    public PagingVO<CgOrderVO> page(CgOrderPageParam cgOrderPageParam) {
        List<Predicate> where = where(cgOrderPageParam);
        JPAQuery<CgOrderVO> query = select(CgOrderVO.class).where(ExpressionUtils.allOf(where));
        cgOrderPageParam.setPaging(query);
        cgOrderPageParam.fillOrders(query, qCgOrderDO);
        return PagingVO.<CgOrderVO>builder()
                .total(query.fetch().size())
                .records(query.fetch())
                .build();
    }
    public CgOrderVO queryById(Long id){
      return   select(CgOrderVO.class)
                .where(qCgOrderDO.id.eq(id))
                .fetchOne();
    }

    public List<CgOrderVO> queryByIds(List<Long> id){
        return   select(CgOrderVO.class)
                .where(qCgOrderDO.id.in(id))
                .fetch();
    }
    public List<CgOrderVO> export(CgOrderPageParam cgOrderPageParam){
        List<Predicate> where = where(cgOrderPageParam);
      return   select(CgOrderVO.class)
                .where(ExpressionUtils.allOf(where))
                .fetch();
    }
    public void updateAmtById(Long id, BigDecimal unAmt,BigDecimal amt){
        jpaQueryFactory.update(qCgOrderDO)
                .set(qCgOrderDO.unrefundAmt,unAmt)
                .set(qCgOrderDO.refundAmt,amt)
                .where(qCgOrderDO.id.eq(id))
                .execute();
    }
    public void updateByIds(List<Long> ids, String status, SysUserDTO sysUserDTO){
        jpaQueryFactory.update(qCgOrderDO)
                .set(qCgOrderDO.state,status)
                .set(qCgOrderDO.auditTime, LocalDateTime.now())
                .set(qCgOrderDO.auditUser,sysUserDTO.getUsername())
                .set(qCgOrderDO.auditUserId, sysUserDTO.getId())
                .where(qCgOrderDO.id.in(ids))
                .execute();
    }

    public void updateByIds(List<Long> ids, String status, SysUserDTO sysUserDTO,String reason){
        jpaQueryFactory.update(qCgOrderDO)
                .set(qCgOrderDO.state,status)
                .set(qCgOrderDO.auditTime, LocalDateTime.now())
                .set(qCgOrderDO.auditUser,sysUserDTO.getUsername())
                .set(qCgOrderDO.auditUserId, sysUserDTO.getId())
                .set(qCgOrderDO.auditRejectReason,reason)
                .where(qCgOrderDO.id.in(ids))
                .execute();
    }

    private List<Predicate> where(CgOrderPageParam cgOrderPageParam){
        List<Predicate> predicates = new ArrayList<>();
        if(!CollectionUtils.isEmpty(cgOrderPageParam.getIds())){
            predicates.add(qCgOrderDO.id.in(cgOrderPageParam.getIds()));
        }
        if(!CollectionUtils.isEmpty(cgOrderPageParam.getType())){
            predicates.add(qCgOrderDO.type.in(cgOrderPageParam.getType()));
        }
        if(!CollectionUtils.isEmpty(cgOrderPageParam.getState())){
            predicates.add(qCgOrderDO.state.in(cgOrderPageParam.getState()));
        }
        if(!CollectionUtils.isEmpty(cgOrderPageParam.getRecType())){
            predicates.add(qCgOrderDO.recType.in(cgOrderPageParam.getRecType()));
        }
        if(!StringUtils.isEmpty(cgOrderPageParam.getDocNo())){
            predicates.add(qCgOrderDO.docNo.like("%"+cgOrderPageParam.getDocNo()+"%"));
        }
        if(!StringUtils.isEmpty(cgOrderPageParam.getAccName())){
            predicates.add(qCgOrderDO.accName.like("%"+cgOrderPageParam.getAccName()+"%"));
        }
        if(!StringUtils.isEmpty(cgOrderPageParam.getPayBankAcc())){
            predicates.add(qCgOrderDO.payBankAcc.like("%"+cgOrderPageParam.getPayBankAcc()+"%"));
        }
        if(!StringUtils.isEmpty(cgOrderPageParam.getRecBankAcc())){
            predicates.add(qCgOrderDO.recBankAcc.like("%"+cgOrderPageParam.getRecBankAcc()+"%"));
        }
        if(cgOrderPageParam.getAuditTimeS()!=null&&cgOrderPageParam.getAuditTimeE()!=null){
            predicates.add(qCgOrderDO.auditTime.between(cgOrderPageParam.getAuditTimeS(),cgOrderPageParam.getAuditTimeE()));
        }else{
            if(cgOrderPageParam.getAuditTimeS()!=null){
                predicates.add(qCgOrderDO.auditTime.after(cgOrderPageParam.getAuditTimeS()));
            }
            if(cgOrderPageParam.getAuditTimeE()!=null){
                predicates.add(qCgOrderDO.auditTime.after(cgOrderPageParam.getAuditTimeE()));
            }
        }
        if(cgOrderPageParam.getCgTimeS()!=null&&cgOrderPageParam.getCgTimeE()!=null){
            predicates.add(qCgOrderDO.cgTime.between(cgOrderPageParam.getCgTimeS(),cgOrderPageParam.getCgTimeE()));
        }else{
            if(cgOrderPageParam.getCgTimeS()!=null){
                predicates.add(qCgOrderDO.cgTime.after(cgOrderPageParam.getCgTimeS()));
            }
            if(cgOrderPageParam.getCgTimeE()!=null){
                predicates.add(qCgOrderDO.cgTime.after(cgOrderPageParam.getCgTimeE()));
            }
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qCgOrderDO.id,
                qCgOrderDO.state,
                qCgOrderDO.type,
                qCgOrderDO.accCode,
                qCgOrderDO.accName,
                qCgOrderDO.auditTime,
                qCgOrderDO.auditRejectReason,
                qCgOrderDO.cgTime,
                qCgOrderDO.docNo,
                qCgOrderDO.createTime,
                qCgOrderDO.creator,
                qCgOrderDO.totalAmt,
                qCgOrderDO.remark,
                qCgOrderDO.recType,
                qCgOrderDO.recBankAcc,
                qCgOrderDO.recBankName,
                qCgOrderDO.payOpenBank,
                qCgOrderDO.payBankAcc,
                qCgOrderDO.ouId,
                qCgOrderDO.ouCode,
                qCgOrderDO.ouName,
                qCgOrderDO.sourceNo,
                qCgOrderDO.refundAmt,
                qCgOrderDO.unrefundAmt
        )).from(qCgOrderDO);
    }

}
