/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.account;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.application.convert.account.AccountConvert;
import com.elitesland.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.account.AccountDO;
import com.elitesland.fin.repo.account.AccountRepo;
import com.elitesland.fin.repo.account.AccountRepoProc;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountServiceImpl
implements AccountService {
    private final AccountRepoProc accountRepoProc;
    private final AccountRepo accountRepo;

    @Override
    @Transactional
    public Long save(AccountParam accountParam) {
        if (null == accountParam.getState()) {
            accountParam.setState(UdcEnum.FIN_ENABLE_STATE_ENABLE.getValueCode());
        }
        AccountDO accountDO = AccountConvert.INSTANCE.p2En(accountParam);
        AccountDO res = (AccountDO)((Object)this.accountRepo.save((Object)accountDO));
        return res.getId();
    }

    @Override
    public AccountVO get(Long id) {
        AccountDO accountDO = (AccountDO)((Object)this.accountRepo.findById(id).get());
        AccountVO res = AccountConvert.INSTANCE.en2Vo(accountDO);
        return res;
    }

    @Override
    public PagingVO<AccountVO> page(AccountPageParam accountPageParam) {
        PagingVO<AccountVO> res = this.accountRepoProc.page(accountPageParam);
        return res;
    }

    @Override
    @Transactional
    public Long updateState(AccountParam accountParam) {
        if (null == accountParam.getId()) {
            throw new BusinessException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long res = this.accountRepoProc.updateState(accountParam);
        return res;
    }

    public AccountServiceImpl(AccountRepoProc accountRepoProc, AccountRepo accountRepo) {
        this.accountRepoProc = accountRepoProc;
        this.accountRepo = accountRepo;
    }
}

