/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.cgorder;

import com.alibaba.excel.EasyExcelFactory;
import com.cloudt.apm.common.exception.BusinessException;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.fin.application.convert.cgorder.CgOrderConvert;
import com.elitesland.fin.application.facade.param.cgorder.CgOrderPageParam;
import com.elitesland.fin.application.facade.param.cgorder.CgOrderParam;
import com.elitesland.fin.application.facade.vo.cgorder.CgOrderVO;
import com.elitesland.fin.application.service.cgorder.CgOrderService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.cgorder.CgOrderDO;
import com.elitesland.fin.repo.cgorder.CgOrderRepo;
import com.elitesland.fin.repo.cgorder.CgOrderRepoProc;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CgOrderServiceImpl
implements CgOrderService {
    private final CgOrderRepo cgOrderRepo;
    private final CgOrderRepoProc cgOrderRepoProc;
    @Autowired
    private SeqNumProvider sysNumberRuleService;

    @Override
    @SysCodeProc
    public PagingVO<CgOrderVO> page(CgOrderPageParam cgOrderPageParam) {
        return this.cgOrderRepoProc.page(cgOrderPageParam);
    }

    @Override
    @SysCodeProc
    public CgOrderVO getOne(Long id) {
        return this.cgOrderRepoProc.queryById(id);
    }

    @Override
    public void export(CgOrderPageParam cgOrderPageParam, HttpServletResponse response) {
        PagingVO<CgOrderVO> page = this.cgOrderRepoProc.page(cgOrderPageParam);
        try {
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode("", "UTF-8").replace("+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            EasyExcelFactory.write((OutputStream)response.getOutputStream(), CgOrderVO.class).sheet("").doWrite(page.getRecords());
        }
        catch (IOException e) {
            throw new BusinessException("\u5bfc\u51fa\u5931\u8d25!");
        }
    }

    @Override
    public List<Long> approve(List<Long> ids) {
        List<CgOrderVO> cgOrderVO = this.cgOrderRepoProc.queryByIds(ids);
        cgOrderVO.forEach(vo -> {
            if (!vo.getState().equals(UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode())) {
                throw new BusinessException("\u53ea\u6709\u8349\u7a3f\u72b6\u6001\u5355\u636e\u624d\u53ef\u62d2\u7edd!");
            }
        });
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u9646\u4eba\u4fe1\u606f\u83b7\u53d6\u4e3a\u7a7a!");
        }
        this.cgOrderRepoProc.updateByIds(ids, UdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode(), userDetails.getUser());
        return ids;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> reject(CgOrderParam cgOrderParam) {
        List<CgOrderVO> cgOrderVO = this.cgOrderRepoProc.queryByIds(cgOrderParam.getIds());
        cgOrderVO.forEach(vo -> {
            if (!vo.getState().equals(UdcEnum.COM_APPLY_STATUS_DOING.getValueCode())) {
                throw new BusinessException("\u53ea\u6709\u5ba1\u6279\u4e2d\u72b6\u6001\u5355\u636e\u624d\u53ef\u62d2\u7edd!");
            }
        });
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u9646\u4eba\u4fe1\u606f\u83b7\u53d6\u4e3a\u7a7a!");
        }
        this.cgOrderRepoProc.updateByIds(cgOrderParam.getIds(), UdcEnum.COM_APPR_STATUS_REJECTED.getValueCode(), userDetails.getUser());
        return cgOrderParam.getIds();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> cancel(List<Long> ids) {
        List<CgOrderVO> cgOrderVO = this.cgOrderRepoProc.queryByIds(ids);
        cgOrderVO.forEach(vo -> {
            if (!vo.getState().equals(UdcEnum.COM_APPLY_STATUS_REJECTED.getValueCode())) {
                throw new BusinessException("\u53ea\u6709\u5ba1\u6279\u62d2\u7edd\u72b6\u6001\u5355\u636e\u624d\u53ef\u4f5c\u5e9f!");
            }
        });
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u9646\u4eba\u4fe1\u606f\u83b7\u53d6\u4e3a\u7a7a!");
        }
        this.cgOrderRepoProc.updateByIds(ids, UdcEnum.COM_APPLY_STATUS_VOID.getValueCode(), userDetails.getUser());
        return ids;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long returnCg(CgOrderParam cgOrderParam) {
        CgOrderVO cgOrderVO = this.cgOrderRepoProc.queryById(cgOrderParam.getId());
        if (!(cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0001.getValueCode()) || cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0002.getValueCode()) || cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0003.getValueCode()) || cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0004.getValueCode()) || cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0005.getValueCode()) || cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0006.getValueCode()) || cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0007.getValueCode()) || cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0008.getValueCode()))) {
            throw new BusinessException("\u53ea\u80fd\u9000\u8fd8\u4fdd\u8bc1\u91d1\u7c7b\u578b\u5355\u636e!");
        }
        if (!cgOrderVO.getState().equals(UdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode())) {
            throw new BusinessException("\u53ea\u80fd\u9000\u8fd8\u5df2\u5ba1\u6279\u7684\u5355\u636e!");
        }
        if (cgOrderParam.getReturnAmt().compareTo(BigDecimal.ZERO) <= 0) {
            throw new BusinessException("\u9000\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0!");
        }
        if (cgOrderParam.getReturnAmt().compareTo(cgOrderVO.getUnrefundAmt()) > 0) {
            throw new BusinessException("\u9000\u6b3e\u91d1\u989d\u5927\u4e8e\u672a\u9000\u6b3e\u91d1\u989d!");
        }
        BigDecimal unReturnAmt = cgOrderVO.getUnrefundAmt().subtract(cgOrderParam.getReturnAmt());
        BigDecimal returnAmt = cgOrderVO.getRefundAmt().subtract(cgOrderParam.getReturnAmt());
        this.cgOrderRepoProc.updateAmtById(cgOrderParam.getId(), unReturnAmt, returnAmt);
        CgOrderDO cgOrderDO = CgOrderConvert.INSTANCE.voToDo(cgOrderVO);
        cgOrderDO.setAuditRejectReason(null);
        cgOrderDO.setAuditTime(null);
        cgOrderDO.setAuditUserId(null);
        cgOrderDO.setAuditUser(null);
        cgOrderDO.setState(UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode());
        cgOrderDO.setType(UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0004.getValueCode());
        String docNo = this.sysNumberRuleService.generateCode("yst-fin", "CG_ORDER", new ArrayList());
        cgOrderDO.setDocNo(docNo);
        cgOrderDO.setTotalAmt(cgOrderParam.getReturnAmt());
        cgOrderDO.setSourceNo(cgOrderVO.getDocNo());
        cgOrderDO.setSourceId(cgOrderVO.getId());
        return null;
    }

    public CgOrderServiceImpl(CgOrderRepo cgOrderRepo, CgOrderRepoProc cgOrderRepoProc) {
        this.cgOrderRepo = cgOrderRepo;
        this.cgOrderRepoProc = cgOrderRepoProc;
    }
}

