/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.workflow.inputinv;

import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitesland.fin.application.service.workflow.inputinv.InputInvProcessService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.inputinv.QInputInvDO;
import com.elitesland.fin.infr.dto.inputinv.InputInvDTO;
import com.elitesland.fin.infr.repo.inputinv.InputInvRepoProc;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InputInvProcessServiceImpl
implements InputInvProcessService {
    private static final Logger log = LoggerFactory.getLogger(InputInvProcessServiceImpl.class);
    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    private final InputInvRepoProc inputInvRepoProc;
    private final JPAQueryFactory jpaQueryFactory;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        InputInvDTO inputInvDTO = this.inputInvRepoProc.queryById(id);
        if (inputInvDTO == null) {
            throw new BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        QInputInvDO inputInvDO = QInputInvDO.inputInvDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)inputInvDO).set(inputInvDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{inputInvDO.id.eq((Object)id)});
        switch (procInstStatus) {
            case NOTSUBMIT: {
                jpaUpdateClause.set((Path)inputInvDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode());
                break;
            }
            case INTERRUPT: {
                jpaUpdateClause.set((Path)inputInvDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode()).set((Path)inputInvDO.procInstId, (Object)null);
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)inputInvDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode()).set(inputInvDO.approvedTime, (Object)LocalDateTime.now()).set(inputInvDO.auditDate, (Object)LocalDateTime.now()).set(inputInvDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)inputInvDO.auditRejection, (Object)commentInfo.getComment()).set((Path)inputInvDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)inputInvDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode()).set(inputInvDO.auditDate, (Object)LocalDateTime.now()).set(inputInvDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)inputInvDO.auditRejection, (Object)commentInfo.getComment()).set((Path)inputInvDO.auditUser, (Object)commentInfo.getUserName()).set((Path)inputInvDO.procInstId, (Object)null);
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)inputInvDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_DOING.getValueCode()).set(inputInvDO.submitTime, (Object)LocalDateTime.now());
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)inputInvDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode()).set(inputInvDO.approvedTime, (Object)LocalDateTime.now()).set(inputInvDO.auditDate, (Object)LocalDateTime.now()).set(inputInvDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)inputInvDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
        }
        jpaUpdateClause.execute();
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        Long businessId = Long.valueOf(businessKey);
        InputInvDTO inputInvDTO = this.inputInvRepoProc.queryById(businessId);
        if (inputInvDTO == null) {
            throw new BusinessException("\u5355\u636e(id:" + businessId + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        SysUserIdFlowRoleRpcParam param = SysUserIdFlowRoleRpcParam.builder().ouIds(Collections.singletonList(inputInvDTO.getOuId())).flowRoleCodes(Collections.singletonList(customParams)).build();
        List userIdsByFlowRoles = this.sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
        return userIdsByFlowRoles.stream().map(e -> "" + e).collect(Collectors.toCollection(ArrayList::new));
    }

    public InputInvProcessServiceImpl(SysUserFlowRoleRpcService sysUserFlowRoleRpcService, InputInvRepoProc inputInvRepoProc, JPAQueryFactory jpaQueryFactory) {
        this.sysUserFlowRoleRpcService = sysUserFlowRoleRpcService;
        this.inputInvRepoProc = inputInvRepoProc;
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

