/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.workflow.payorder;

import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitesland.fin.application.service.payorder.PayOrderService;
import com.elitesland.fin.application.service.workflow.payorder.PayOrderProcessService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.payorder.QPayOrderDO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PayOrderProcessServiceImpl
implements PayOrderProcessService {
    private static final Logger log = LoggerFactory.getLogger(PayOrderProcessServiceImpl.class);
    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    private final PayOrderRepoProc payOrderRepoProc;
    private final JPAQueryFactory jpaQueryFactory;
    private final PayOrderService payOrderService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        PayOrderDTO payOrderDTO = this.payOrderRepoProc.queryById(id);
        if (payOrderDTO == null) {
            throw new BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        QPayOrderDO payOrderDO = QPayOrderDO.payOrderDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)payOrderDO).set(payOrderDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{payOrderDO.id.eq((Object)id)});
        switch (procInstStatus) {
            case NOTSUBMIT: {
                jpaUpdateClause.set((Path)payOrderDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode());
                break;
            }
            case INTERRUPT: {
                jpaUpdateClause.set((Path)payOrderDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode()).set((Path)payOrderDO.procInstId, (Object)null);
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)payOrderDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_DOING.getValueCode()).set(payOrderDO.submitTime, (Object)LocalDateTime.now());
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)payOrderDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode()).set(payOrderDO.approvedTime, (Object)LocalDateTime.now()).set(payOrderDO.auditDate, (Object)LocalDateTime.now()).set(payOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)payOrderDO.auditRejection, (Object)commentInfo.getComment()).set((Path)payOrderDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)payOrderDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode()).set(payOrderDO.approvedTime, (Object)LocalDateTime.now()).set(payOrderDO.auditDate, (Object)LocalDateTime.now()).set(payOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)payOrderDO.auditRejection, (Object)commentInfo.getComment()).set((Path)payOrderDO.auditUser, (Object)commentInfo.getUserName()).set((Path)payOrderDO.procInstId, (Object)null);
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)payOrderDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode()).set(payOrderDO.approvedTime, (Object)LocalDateTime.now()).set(payOrderDO.auditDate, (Object)LocalDateTime.now()).set(payOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)payOrderDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
        }
        jpaUpdateClause.execute();
        if (procInstStatus.equals((Object)ProcInstStatus.APPROVED)) {
            this.payOrderService.approved(id);
        }
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        Long businessId = Long.valueOf(businessKey);
        PayOrderDTO payOrderDTO = this.payOrderRepoProc.queryById(businessId);
        if (payOrderDTO == null) {
            throw new BusinessException("\u5355\u636e(id:" + businessId + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        SysUserIdFlowRoleRpcParam param = SysUserIdFlowRoleRpcParam.builder().ouIds(Collections.singletonList(payOrderDTO.getOuId())).flowRoleCodes(Collections.singletonList(customParams)).build();
        List userIdsByFlowRoles = this.sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
        return userIdsByFlowRoles.stream().map(e -> "" + e).collect(Collectors.toCollection(ArrayList::new));
    }

    public PayOrderProcessServiceImpl(SysUserFlowRoleRpcService sysUserFlowRoleRpcService, PayOrderRepoProc payOrderRepoProc, JPAQueryFactory jpaQueryFactory, PayOrderService payOrderService) {
        this.sysUserFlowRoleRpcService = sysUserFlowRoleRpcService;
        this.payOrderRepoProc = payOrderRepoProc;
        this.jpaQueryFactory = jpaQueryFactory;
        this.payOrderService = payOrderService;
    }
}

