/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.workflow.recorder;

import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitesland.fin.application.service.workflow.recorder.RecOrderProcessService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.recorder.QRecOrderDO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RecOrderProcessServiceImpl
implements RecOrderProcessService {
    private static final Logger log = LoggerFactory.getLogger(RecOrderProcessServiceImpl.class);
    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    private final RecOrderRepoProc recOrderRepoProc;
    private final JPAQueryFactory jpaQueryFactory;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        RecOrderDTO recOrderDTO = this.recOrderRepoProc.queryById(id);
        if (recOrderDTO == null) {
            throw new BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        QRecOrderDO recOrderDO = QRecOrderDO.recOrderDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)recOrderDO).set(recOrderDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{recOrderDO.id.eq((Object)id)});
        switch (procInstStatus) {
            case NOTSUBMIT: {
                jpaUpdateClause.set((Path)recOrderDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode());
                break;
            }
            case INTERRUPT: {
                jpaUpdateClause.set((Path)recOrderDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode()).set((Path)recOrderDO.procInstId, (Object)null);
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)recOrderDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_DOING.getValueCode()).set(recOrderDO.submitTime, (Object)LocalDateTime.now());
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)recOrderDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode()).set(recOrderDO.approvedTime, (Object)LocalDateTime.now()).set(recOrderDO.auditDate, (Object)LocalDateTime.now()).set(recOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)recOrderDO.auditRejection, (Object)commentInfo.getComment()).set((Path)recOrderDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)recOrderDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode()).set(recOrderDO.approvedTime, (Object)LocalDateTime.now()).set(recOrderDO.auditDate, (Object)LocalDateTime.now()).set(recOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)recOrderDO.auditRejection, (Object)commentInfo.getComment()).set((Path)recOrderDO.auditUser, (Object)commentInfo.getUserName()).set((Path)recOrderDO.procInstId, (Object)null);
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)recOrderDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode()).set(recOrderDO.approvedTime, (Object)LocalDateTime.now()).set(recOrderDO.auditDate, (Object)LocalDateTime.now()).set(recOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)recOrderDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
        }
        jpaUpdateClause.execute();
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        Long businessId = Long.valueOf(businessKey);
        RecOrderDTO recOrderDTO = this.recOrderRepoProc.queryById(businessId);
        if (recOrderDTO == null) {
            throw new BusinessException("\u5355\u636e(id:" + businessId + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        SysUserIdFlowRoleRpcParam param = SysUserIdFlowRoleRpcParam.builder().ouIds(Collections.singletonList(recOrderDTO.getOuId())).flowRoleCodes(Collections.singletonList(customParams)).build();
        List userIdsByFlowRoles = this.sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
        return userIdsByFlowRoles.stream().map(e -> "" + e).collect(Collectors.toCollection(ArrayList::new));
    }

    public RecOrderProcessServiceImpl(SysUserFlowRoleRpcService sysUserFlowRoleRpcService, RecOrderRepoProc recOrderRepoProc, JPAQueryFactory jpaQueryFactory) {
        this.sysUserFlowRoleRpcService = sysUserFlowRoleRpcService;
        this.recOrderRepoProc = recOrderRepoProc;
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

