/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.apordertopay;

import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitesland.fin.application.convert.apordertopay.ApOrderToPayConvert;
import com.elitesland.fin.domain.entity.apordertopay.ApOrderToPay;
import com.elitesland.fin.domain.entity.apordertopay.ApOrderToPayDO;
import com.elitesland.fin.domain.service.apordertopay.ApOrderToPayDomainService;
import com.elitesland.fin.infr.dto.apordertopay.ApOrderToPayDTO;
import com.elitesland.fin.infr.repo.apordertopay.ApOrderToPayRepo;
import com.elitesland.fin.infr.repo.apordertopay.ApOrderToPayRepoProc;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApOrderToPayDomainServiceImpl
implements ApOrderToPayDomainService {
    private final ApOrderToPayRepo apOrderToPayRepo;
    private final ApOrderToPayRepoProc apOrderToPayRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> save(List<ApOrderToPay> orderToPays) {
        List<ApOrderToPayDO> apOrderToPayDOS = ApOrderToPayConvert.INSTANCE.convertDo(orderToPays);
        orderToPays.forEach(ApOrderToPay::checkNotNull);
        List order = this.apOrderToPayRepo.saveAll(apOrderToPayDOS);
        return order.stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByPayId(Long payId) {
        this.apOrderToPayRepoProc.deleteByPayId(payId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByPayIds(List<Long> payIds) {
        this.apOrderToPayRepoProc.deleteByPayIds(payIds);
    }

    @Override
    public List<ApOrderToPayDTO> queryByApId(List<Long> apIds) {
        return this.apOrderToPayRepoProc.queryByApIds(apIds);
    }

    public ApOrderToPayDomainServiceImpl(ApOrderToPayRepo apOrderToPayRepo, ApOrderToPayRepoProc apOrderToPayRepoProc) {
        this.apOrderToPayRepo = apOrderToPayRepo;
        this.apOrderToPayRepoProc = apOrderToPayRepoProc;
    }
}

